/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.plugin;

import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.util.Optional;
import java.util.UUID;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.ehrbase.plugin.AbstractPluginAspect;
import org.ehrbase.plugin.dto.CompositionIdWithVersionAndEhrId;
import org.ehrbase.plugin.dto.CompositionVersionIdWithEhrId;
import org.ehrbase.plugin.dto.CompositionWithEhrId;
import org.ehrbase.plugin.dto.CompositionWithEhrIdAndPreviousVersion;
import org.ehrbase.plugin.extensionpoints.CompositionExtensionPoint;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@Aspect
@ConditionalOnProperty(prefix="plugin-manager", name={"enable"}, havingValue="true")
public class CompositionPluginAspect
extends AbstractPluginAspect<CompositionExtensionPoint> {
    public CompositionPluginAspect(ListableBeanFactory beanFactory) {
        super(beanFactory, CompositionExtensionPoint.class);
    }

    @Around(value="inServiceLayerPC() && execution(* org.ehrbase.api.service.CompositionService.create(..))")
    public Object aroundCreateComposition(ProceedingJoinPoint pjp) {
        return Optional.of(this.proceedWithPluginExtensionPoints(pjp, CompositionExtensionPoint::aroundCreation, args -> new CompositionWithEhrId((Composition)args[1], (UUID)args[0]), (i, args) -> {
            args[1] = i.getComposition();
            args[0] = i.getEhrId();
            return args;
        }, ret -> (UUID)((Optional)ret).orElseThrow()));
    }

    @Around(value="inServiceLayerPC() && execution(* org.ehrbase.api.service.CompositionService.update(..))")
    public Object aroundUpdateComposition(ProceedingJoinPoint pjp) {
        return Optional.of(this.proceedWithPluginExtensionPoints(pjp, CompositionExtensionPoint::aroundUpdate, args -> new CompositionWithEhrIdAndPreviousVersion((Composition)args[2], (ObjectVersionId)args[1], (UUID)args[0]), (i, args) -> {
            args[2] = i.getComposition();
            args[1] = i.getPreviousVersion();
            args[0] = i.getEhrId();
            return args;
        }, ret -> (UUID)((Optional)ret).orElseThrow()));
    }

    @Around(value="inServiceLayerPC() && execution(* org.ehrbase.api.service.CompositionService.delete(..))")
    public void aroundDeleteComposition(ProceedingJoinPoint pjp) {
        this.proceedWithPluginExtensionPoints(pjp, CompositionExtensionPoint::aroundDelete, args -> new CompositionVersionIdWithEhrId((ObjectVersionId)args[1], (UUID)args[0]), (i, args) -> {
            args[1] = i.getVersionId();
            args[0] = i.getEhrId();
            return args;
        }, Void.class::cast);
    }

    @Around(value="inServiceLayerPC() && execution(* org.ehrbase.api.service.CompositionService.retrieve(..))")
    public Object aroundRetrieveComposition(ProceedingJoinPoint pjp) {
        return this.proceedWithPluginExtensionPoints(pjp, CompositionExtensionPoint::aroundRetrieve, args -> new CompositionIdWithVersionAndEhrId((UUID)args[0], (UUID)args[1], (Integer)args[2]), (i, args) -> {
            args[2] = i.getVersion();
            args[1] = i.getCompositionId();
            args[0] = i.getEhrId();
            return args;
        });
    }
}

