/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.repository;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.generic.AuditDetails;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.support.identification.TerminologyId;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.api.exception.UnexpectedSwitchCaseException;
import org.ehrbase.api.service.ContributionService;
import org.ehrbase.api.service.SystemService;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.enums.ContributionChangeType;
import org.ehrbase.jooq.pg.enums.ContributionDataType;
import org.ehrbase.jooq.pg.tables.Contribution;
import org.ehrbase.jooq.pg.tables.records.AuditDetailsRecord;
import org.ehrbase.jooq.pg.tables.records.ContributionRecord;
import org.ehrbase.openehr.sdk.serialisation.jsonencoding.CanonicalJson;
import org.ehrbase.repository.AuditDetailsTargetType;
import org.ehrbase.repository.PartyProxyRepository;
import org.ehrbase.service.TimeProvider;
import org.ehrbase.service.UserService;
import org.ehrbase.util.UuidGenerator;
import org.jooq.DSLContext;
import org.jooq.JSONB;
import org.jooq.Table;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class ContributionRepository {
    private final DSLContext context;
    private final SystemService systemService;
    private final UserService userService;
    private final PartyProxyRepository partyProxyRepository;
    private final TimeProvider timeProvider;

    public ContributionRepository(DSLContext context, SystemService systemService, UserService userService, PartyProxyRepository partyProxyRepository, TimeProvider timeProvider) {
        this.context = context;
        this.systemService = systemService;
        this.userService = userService;
        this.partyProxyRepository = partyProxyRepository;
        this.timeProvider = timeProvider;
    }

    @Transactional
    public UUID createDefault(UUID ehrId, ContributionDataType contributionType, ContributionChangeType contributionChangeType) {
        UUID auditDetailsRecordId = this.createDefaultAudit(contributionChangeType, AuditDetailsTargetType.CONTRIBUTION);
        return this.createContribution(ehrId, UuidGenerator.randomUUID(), contributionType, auditDetailsRecordId);
    }

    @Transactional
    public UUID createDefaultAudit(ContributionChangeType contributionChangeType, AuditDetailsTargetType targetType) {
        AuditDetailsRecord auditDetailsRecord = (AuditDetailsRecord)this.context.newRecord((Table)org.ehrbase.jooq.pg.tables.AuditDetails.AUDIT_DETAILS);
        auditDetailsRecord.setId(UuidGenerator.randomUUID());
        auditDetailsRecord.setTimeCommitted(this.timeProvider.getNow());
        auditDetailsRecord.setTargetType(targetType.getAlias());
        auditDetailsRecord.setCommitter(null);
        auditDetailsRecord.setUserId(this.userService.getCurrentUserId());
        auditDetailsRecord.setChangeType(contributionChangeType);
        auditDetailsRecord.store();
        return auditDetailsRecord.getId();
    }

    @Transactional
    public UUID createContribution(UUID ehrId, UUID contributionUuid, ContributionDataType contributionType, UUID auditDetailsRecordId) {
        ContributionRecord contributionRecord = (ContributionRecord)this.context.newRecord((Table)Contribution.CONTRIBUTION);
        contributionRecord.setEhrId(ehrId);
        contributionRecord.setId(contributionUuid);
        contributionRecord.setContributionType(contributionType);
        contributionRecord.setHasAudit(auditDetailsRecordId);
        contributionRecord.store();
        return contributionRecord.getId();
    }

    @Transactional
    public UUID createAudit(AuditDetails auditDetails, AuditDetailsTargetType targetType) {
        AuditDetailsRecord auditDetailsRecord = (AuditDetailsRecord)this.context.newRecord((Table)org.ehrbase.jooq.pg.tables.AuditDetails.AUDIT_DETAILS);
        auditDetailsRecord.setId(UuidGenerator.randomUUID());
        auditDetailsRecord.setTimeCommitted(this.timeProvider.getNow());
        if (!this.partyProxyRepository.fromUser(this.userService.getCurrentUserId()).equals((Object)auditDetails.getCommitter())) {
            auditDetailsRecord.setCommitter(JSONB.jsonb((String)new CanonicalJson().marshal((RMObject)auditDetails.getCommitter())));
        }
        auditDetailsRecord.setTargetType(targetType.getAlias());
        auditDetailsRecord.setChangeType(this.to(auditDetails.getChangeType()));
        auditDetailsRecord.setDescription((String)Optional.ofNullable(auditDetails.getDescription()).map(DvText::getValue).orElse(null));
        auditDetailsRecord.setUserId(this.userService.getCurrentUserId());
        auditDetailsRecord.store();
        return auditDetailsRecord.getId();
    }

    private ContributionChangeType to(DvCodedText changeType) {
        return switch (changeType.getDefiningCode().getCodeString()) {
            case "249" -> ContributionChangeType.creation;
            case "250" -> ContributionChangeType.amendment;
            case "251" -> ContributionChangeType.modification;
            case "252" -> ContributionChangeType.synthesis;
            case "253" -> ContributionChangeType.Unknown;
            case "523" -> ContributionChangeType.deleted;
            default -> throw new UnexpectedSwitchCaseException(changeType.toString());
        };
    }

    public ContributionRecord findById(UUID contibutionId) {
        return (ContributionRecord)this.context.fetchOne((Table)Tables.CONTRIBUTION, Tables.CONTRIBUTION.ID.eq((Object)contibutionId));
    }

    public AuditDetails findAuditDetails(UUID auditId) {
        AuditDetailsRecord auditDetailsRecord = (AuditDetailsRecord)this.context.fetchOne((Table)org.ehrbase.jooq.pg.tables.AuditDetails.AUDIT_DETAILS, Tables.AUDIT_DETAILS.ID.eq((Object)auditId));
        Objects.requireNonNull(auditDetailsRecord);
        AuditDetails auditDetails = new AuditDetails();
        auditDetails.setSystemId(this.systemService.getSystemId());
        if (auditDetailsRecord.getCommitter() != null) {
            auditDetails.setCommitter((PartyProxy)new CanonicalJson().unmarshal(auditDetailsRecord.getCommitter().data(), PartyProxy.class));
        } else {
            auditDetails.setCommitter(this.partyProxyRepository.fromUser(auditDetailsRecord.getUserId()));
        }
        auditDetails.setDescription(new DvText(auditDetailsRecord.getDescription()));
        DvCodedText changeType = new DvCodedText(auditDetailsRecord.getChangeType().getLiteral(), new CodePhrase(new TerminologyId("openehr"), Integer.toString(ContributionService.ContributionChangeType.valueOf((String)auditDetailsRecord.getChangeType().getLiteral().toUpperCase()).getCode())));
        auditDetails.setChangeType(changeType);
        DvDateTime time = new DvDateTime((TemporalAccessor)auditDetailsRecord.getTimeCommitted());
        auditDetails.setTimeCommitted(time);
        return auditDetails;
    }
}

