/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.repository;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Locatable;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.openehr.aqlengine.asl.model.AslRmTypeAndConcept;
import org.ehrbase.openehr.dbformat.StructureIndex;
import org.ehrbase.openehr.dbformat.StructureNode;
import org.ehrbase.openehr.dbformat.StructureRmType;
import org.ehrbase.openehr.dbformat.VersionedObjectDataStructure;
import org.ehrbase.openehr.dbformat.jooq.prototypes.ObjectDataRecordPrototype;
import org.ehrbase.openehr.dbformat.jooq.prototypes.ObjectDataTablePrototype;
import org.ehrbase.openehr.dbformat.jooq.prototypes.ObjectVersionRecordPrototype;
import org.ehrbase.openehr.dbformat.jooq.prototypes.ObjectVersionTablePrototype;
import org.ehrbase.repository.AbstractVersionedObjectRepository;
import org.jooq.DSLContext;
import org.jooq.JSONB;
import org.jooq.Table;

public record VersionDataDbRecord(ObjectVersionRecordPrototype versionRecord, Supplier<Stream<ObjectDataRecordPrototype>> dataRecords) {
    public static VersionDataDbRecord toRecords(UUID ehrId, Locatable versionDataObject, UUID contributionId, UUID auditId, OffsetDateTime now, DSLContext context) {
        List roots = VersionedObjectDataStructure.createDataStructure((RMObject)versionDataObject);
        UUID voId = UUID.fromString(versionDataObject.getUid().getRoot().getValue());
        ObjectVersionRecordPrototype versionRecord = VersionDataDbRecord.buildVersionRecord(context, ehrId, voId, AbstractVersionedObjectRepository.extractVersion(versionDataObject.getUid()), contributionId, auditId, now);
        Supplier<Stream<ObjectDataRecordPrototype>> dataRecords = VersionDataDbRecord.dataRecordsBuilder(voId, roots, context);
        return new VersionDataDbRecord(versionRecord, dataRecords);
    }

    private static ObjectVersionRecordPrototype buildVersionRecord(DSLContext context, UUID ehrId, UUID voId, int sysVersion, UUID contributionId, UUID auditId, OffsetDateTime now) {
        ObjectVersionRecordPrototype objectDataRecord = (ObjectVersionRecordPrototype)context.newRecord((Table)ObjectVersionTablePrototype.INSTANCE);
        objectDataRecord.setEhrId(ehrId);
        objectDataRecord.setVoId(voId);
        objectDataRecord.setSysVersion(Integer.valueOf(sysVersion));
        objectDataRecord.setSysPeriodLower(now);
        objectDataRecord.setAuditId(auditId);
        objectDataRecord.setContributionId(contributionId);
        return objectDataRecord;
    }

    private static Supplier<Stream<ObjectDataRecordPrototype>> dataRecordsBuilder(UUID voId, Collection<StructureNode> nodeList, DSLContext context) {
        return () -> nodeList.stream().filter(r -> r.getStructureRmType().isStructureEntry()).map(n -> VersionDataDbRecord.buildDataRecord(voId, n, context));
    }

    private static ObjectDataRecordPrototype buildDataRecord(UUID voId, StructureNode node, DSLContext context) {
        ObjectDataRecordPrototype rec = (ObjectDataRecordPrototype)context.newRecord((Table)ObjectDataTablePrototype.INSTANCE);
        rec.setNum(Integer.valueOf(node.getNum()));
        rec.setCitemNum((Integer)Optional.of(node).map(StructureNode::getContentItem).map(StructureNode::getNum).orElse(null));
        rec.setRmEntity(((StructureRmType)StructureRmType.byTypeName((String)node.getRmEntity()).orElseThrow(() -> new InternalServerException("No alias for %s".formatted(node.getRmEntity())))).getAlias());
        rec.setEntityConcept(AslRmTypeAndConcept.toEntityConcept((String)node.getArchetypeNodeId()));
        rec.setEntityName(node.getEntityName());
        StructureIndex index = node.getEntityIdx();
        rec.setEntityAttribute(index.printLastAttribute());
        rec.setEntityPath(index.printIndexString(false, false));
        rec.setEntityPathCap(index.printIndexString(true, false));
        rec.setEntityIdx(index.printIndexString(false, true));
        rec.setEntityIdxCap(index.printIndexString(true, true));
        rec.setEntityIdxLen(Integer.valueOf(index.length()));
        rec.setData(JSONB.valueOf((String)VersionedObjectDataStructure.applyRmAliases((ObjectNode)node.getJsonNode()).toString()));
        rec.setVoId(voId);
        return rec;
    }
}

