/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.util;

import java.util.Optional;
import org.ehrbase.util.SemVer;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public record StoredQueryQualifiedName(@NonNull String reverseDomainName, @NonNull String semanticId, @NonNull SemVer semVer) {
    public static StoredQueryQualifiedName create(@NonNull String qualifiedName, @Nullable SemVer version) {
        String[] nameParts = qualifiedName.split("::");
        if (nameParts.length != 2 || qualifiedName.contains("/")) {
            throw new IllegalArgumentException("Qualified name is not valid (https://specifications.openehr.org/releases/SM/latest/openehr_platform.html#_query_service):" + qualifiedName);
        }
        return new StoredQueryQualifiedName(nameParts[0], nameParts[1], Optional.ofNullable(version).orElse(SemVer.NO_VERSION));
    }

    public String toName() {
        return this.reverseDomainName + "::" + this.semanticId;
    }

    public String toQualifiedNameString() {
        StringBuilder sb = new StringBuilder().append(this.reverseDomainName).append("::").append(this.semanticId);
        if (!this.semVer.isNoVersion()) {
            sb.append('/').append(this.semVer);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toQualifiedNameString();
    }
}

