/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.nedap.archie.rm.changecontrol.OriginalVersion;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rm.ehr.VersionedEhrStatus;
import com.nedap.archie.rm.generic.Attestation;
import com.nedap.archie.rm.generic.AuditDetails;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.generic.PartySelf;
import com.nedap.archie.rm.generic.RevisionHistory;
import com.nedap.archie.rm.generic.RevisionHistoryItem;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.PartyRef;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.lang.runtime.SwitchBootstraps;
import java.time.OffsetDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.StateConflictException;
import org.ehrbase.api.exception.UnprocessableEntityException;
import org.ehrbase.api.exception.ValidationException;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.api.service.SystemService;
import org.ehrbase.api.service.ValidationService;
import org.ehrbase.repository.AbstractVersionedObjectRepository;
import org.ehrbase.repository.CompositionRepository;
import org.ehrbase.repository.EhrFolderRepository;
import org.ehrbase.repository.EhrRepository;
import org.ehrbase.util.UuidGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ehrService")
@Transactional
public class EhrServiceImp
implements EhrService {
    public static final String DESCRIPTION = "description";
    public static final String PARTY_ID_ALREADY_USED = "Supplied partyId[%s] is used by a different EHR in the same partyNamespace[%s].";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ValidationService validationService;
    private final EhrFolderRepository ehrFolderRepository;
    private final CompositionRepository compositionRepository;
    private final EhrRepository ehrRepository;
    private final SystemService systemService;

    @Autowired
    public EhrServiceImp(ValidationService validationService, SystemService systemService, EhrFolderRepository ehrFolderRepository, CompositionRepository compositionRepository, EhrRepository ehrRepository) {
        this.validationService = validationService;
        this.ehrFolderRepository = ehrFolderRepository;
        this.compositionRepository = compositionRepository;
        this.ehrRepository = ehrRepository;
        this.systemService = systemService;
    }

    public UUID create(UUID ehrId, EhrStatus status) {
        this.check(status);
        ehrId = Optional.ofNullable(ehrId).orElseGet(UuidGenerator::randomUUID);
        if (this.hasEhr(ehrId)) {
            throw new StateConflictException("EHR with this ID already exists");
        }
        if (status == null) {
            status = new EhrStatus();
            status.setArchetypeNodeId("openEHR-EHR-EHR_STATUS.generic.v1");
            status.setName(new DvText("EHR Status"));
            status.setSubject(new PartySelf(null));
            status.setModifiable(true);
            status.setQueryable(true);
        } else {
            this.checkEhrExistForParty(ehrId, status);
        }
        status.setUid((UIDBasedId)AbstractVersionedObjectRepository.buildObjectVersionId(UuidGenerator.randomUUID(), 1, this.systemService));
        this.ehrRepository.commit(ehrId, status, null, null);
        return ehrId;
    }

    public EhrStatus getEhrStatus(UUID ehrUuid) {
        Optional<EhrStatus> head = this.ehrRepository.findHead(ehrUuid);
        if (head.isEmpty() && !this.hasEhr(ehrUuid)) {
            throw new ObjectNotFoundException("ehr", "No EHR found with given ID: " + ehrUuid.toString());
        }
        return head.orElseThrow();
    }

    public Optional<OriginalVersion<EhrStatus>> getEhrStatusAtVersion(UUID ehrUuid, UUID versionedObjectUid, int version) {
        if (!this.hasEhr(ehrUuid)) {
            throw new ObjectNotFoundException("ehr", "No EHR found with given ID: " + ehrUuid.toString());
        }
        return this.ehrRepository.getOriginalVersionStatus(ehrUuid, versionedObjectUid, version);
    }

    public ObjectVersionId updateStatus(UUID ehrId, EhrStatus status, ObjectVersionId ifMatch, UUID contributionId, UUID audit) {
        if (!this.hasEhr(ehrId)) {
            throw new ObjectNotFoundException("ehr", "No EHR found with given ID: " + ehrId.toString());
        }
        status.setUid((UIDBasedId)ifMatch);
        this.check(status);
        this.checkEhrExistForParty(ehrId, status);
        UUID compId = UUID.fromString(ifMatch.getObjectId().getValue());
        int version = Integer.parseInt(ifMatch.getVersionTreeId().getValue());
        status.setUid((UIDBasedId)AbstractVersionedObjectRepository.buildObjectVersionId(compId, version + 1, this.systemService));
        if (!this.hasEhr(ehrId)) {
            throw new ObjectNotFoundException("ehr", "No EHR found with given ID: " + ehrId.toString());
        }
        this.ehrRepository.update(ehrId, status, contributionId, audit);
        return (ObjectVersionId)status.getUid();
    }

    private void checkEhrExistForParty(UUID ehrId, EhrStatus status) {
        String namespace;
        String subjectId;
        Optional<UUID> ehrIdOpt;
        Optional<PartyRef> partyRef = Optional.ofNullable(status).map(EhrStatus::getSubject).map(PartyProxy::getExternalRef);
        if (partyRef.isPresent() && (ehrIdOpt = this.findBySubject(subjectId = partyRef.get().getId().getValue(), namespace = partyRef.get().getNamespace())).isPresent() && !ehrIdOpt.get().equals(ehrId)) {
            throw new StateConflictException(String.format(PARTY_ID_ALREADY_USED, subjectId, namespace));
        }
    }

    private void check(EhrStatus status) {
        try {
            this.validationService.check(status);
        }
        catch (Exception ex) {
            Exception exception = ex;
            Objects.requireNonNull(exception);
            Exception exception2 = exception;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UnprocessableEntityException.class, IllegalArgumentException.class, ValidationException.class}, (Object)exception2, n)) {
                case 0: {
                    UnprocessableEntityException e = (UnprocessableEntityException)exception2;
                    throw e;
                }
                case 1: {
                    IllegalArgumentException e = (IllegalArgumentException)exception2;
                    throw new ValidationException(e.getMessage(), (Throwable)e);
                }
                case 2: {
                    ValidationException e = (ValidationException)exception2;
                    throw e;
                }
            }
            throw new InternalServerException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Optional<UUID> findBySubject(String subjectId, String nameSpace) {
        return this.ehrRepository.findBySubject(subjectId, nameSpace);
    }

    public DvDateTime getCreationTime(UUID ehrId) {
        if (!this.hasEhr(ehrId)) {
            throw new ObjectNotFoundException("ehr", "No EHR found with given ID: " + ehrId.toString());
        }
        return new DvDateTime((TemporalAccessor)this.ehrRepository.findEhrCreationTime(ehrId));
    }

    public ObjectVersionId getEhrStatusVersionByTimestamp(UUID ehrUid, OffsetDateTime timestamp) {
        if (!this.hasEhr(ehrUid)) {
            throw new ObjectNotFoundException("ehr", "No EHR found with given ID: " + ehrUid.toString());
        }
        return this.ehrRepository.findVersionByTime(ehrUid, timestamp).orElseThrow(() -> new ObjectNotFoundException("ehr_status", "No EHR_STATUS with given timestamp: " + String.valueOf(timestamp)));
    }

    public ObjectVersionId getLatestVersionUidOfStatus(UUID ehrUid) {
        if (!this.hasEhr(ehrUid)) {
            throw new ObjectNotFoundException("ehr", "No EHR found with given ID: " + ehrUid.toString());
        }
        return this.ehrRepository.findLatestVersion(ehrUid).orElseThrow();
    }

    public boolean hasEhr(UUID ehrId) {
        return this.ehrRepository.hasEhr(ehrId);
    }

    public Boolean isModifiable(UUID ehrId) {
        return this.ehrRepository.fetchIsModifiable(ehrId);
    }

    public VersionedEhrStatus getVersionedEhrStatus(UUID ehrUid) {
        if (!this.hasEhr(ehrUid)) {
            throw new ObjectNotFoundException("ehr", "No EHR found with given ID: " + ehrUid.toString());
        }
        return this.ehrRepository.getVersionedEhrStatus(ehrUid).orElseThrow();
    }

    public RevisionHistory getRevisionHistoryOfVersionedEhrStatus(UUID ehrUid) {
        int versions = Integer.parseInt(this.getLatestVersionUidOfStatus(ehrUid).getVersionTreeId().getValue());
        UUID versionedObjectUid = UUID.fromString(this.getLatestVersionUidOfStatus(ehrUid).getObjectId().getValue());
        RevisionHistory revisionHistory = new RevisionHistory();
        for (int i = 1; i <= versions; ++i) {
            Optional<OriginalVersion<EhrStatus>> ehrStatus = this.getEhrStatusAtVersion(ehrUid, versionedObjectUid, i);
            if (!ehrStatus.isPresent()) continue;
            revisionHistory.addItem(this.revisionHistoryItemFromEhrStatus(ehrStatus.get(), i));
        }
        if (revisionHistory.getItems().isEmpty()) {
            throw new InternalServerException("Problem creating RevisionHistory");
        }
        return revisionHistory;
    }

    private RevisionHistoryItem revisionHistoryItemFromEhrStatus(OriginalVersion<EhrStatus> ehrStatus, int version) {
        String statusId = ehrStatus.getUid().getValue().split("::")[0];
        ObjectVersionId objectVersionId = new ObjectVersionId(statusId + "::" + this.systemService.getSystemId() + "::" + version);
        ArrayList<AuditDetails> auditDetailsList = new ArrayList<AuditDetails>();
        auditDetailsList.add(ehrStatus.getCommitAudit());
        if (ehrStatus.getAttestations() != null) {
            for (Attestation a : ehrStatus.getAttestations()) {
                AuditDetails newAudit = new AuditDetails(a.getSystemId(), a.getCommitter(), a.getTimeCommitted(), a.getChangeType(), a.getDescription());
                auditDetailsList.add(newAudit);
            }
        }
        return new RevisionHistoryItem(objectVersionId, auditDetailsList);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    public void adminDeleteEhr(UUID ehrId) {
        this.ehrFolderRepository.adminDelete(ehrId, null);
        this.compositionRepository.adminDeleteAll(ehrId);
        this.ehrRepository.adminDelete(ehrId);
    }

    public List<String> getSubjectExtRefs(Collection<String> ehrIds) {
        return ehrIds.stream().map(this::getSubjectExtRef).toList();
    }

    public String getSubjectExtRef(String ehrId) {
        EhrStatus ehrStatus = this.getEhrStatus(UUID.fromString(ehrId));
        return Optional.of(ehrStatus).map(EhrStatus::getSubject).map(PartyProxy::getExternalRef).map(ObjectRef::getId).map(ObjectId::getValue).orElse(null);
    }
}

