/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.api.exception.UnprocessableEntityException;
import org.ehrbase.api.knowledge.TemplateMetaData;
import org.ehrbase.repository.CompositionRepository;
import org.ehrbase.repository.TemplateStoreRepository;
import org.ehrbase.service.TemplateStorage;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TemplateDBStorageService
implements TemplateStorage {
    private final CompositionRepository compositionRepository;
    private final TemplateStoreRepository templateStoreRepository;

    public TemplateDBStorageService(@Lazy CompositionRepository compositionRepository, TemplateStoreRepository templateStoreRepository) {
        this.compositionRepository = compositionRepository;
        this.templateStoreRepository = templateStoreRepository;
    }

    @Override
    public List<TemplateMetaData> listAllOperationalTemplates() {
        return this.templateStoreRepository.findAll();
    }

    @Override
    public void storeTemplate(OPERATIONALTEMPLATE template) {
        if (this.readOperationaltemplate(template.getTemplateId().getValue()).isEmpty()) {
            this.templateStoreRepository.store(template);
        } else {
            this.checkUsage(template.getTemplateId().getValue(), "update");
            this.templateStoreRepository.update(template);
        }
    }

    @Override
    public Optional<OPERATIONALTEMPLATE> readOperationaltemplate(String templateId) {
        return this.templateStoreRepository.findByTemplateId(templateId);
    }

    private void checkUsage(String templateId, String operation) {
        if (this.compositionRepository.isTemplateUsed(templateId)) {
            throw new UnprocessableEntityException("Cannot %s template %s since it is used by at least one composition".formatted(operation, templateId));
        }
    }

    @Override
    public boolean deleteTemplate(String templateId) {
        this.checkUsage(templateId, "delete");
        this.templateStoreRepository.delete(templateId);
        return true;
    }

    @Override
    public Optional<String> findTemplateIdByUuid(UUID uuid) {
        return this.templateStoreRepository.findTemplateIdByUuid(uuid);
    }

    @Override
    public Optional<UUID> findUuidByTemplateId(String templateId) {
        return this.templateStoreRepository.findUuidByTemplateId(templateId);
    }
}

