/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.repository.experimental;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.ehrbase.api.dto.experimental.ItemTagDto;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.jooq.pg.enums.EhrItemTagTargetType;
import org.ehrbase.jooq.pg.tables.EhrItemTag;
import org.ehrbase.jooq.pg.tables.records.EhrItemTagRecord;
import org.ehrbase.repository.RepositoryHelper;
import org.ehrbase.service.TimeProvider;
import org.ehrbase.util.UuidGenerator;
import org.jooq.DSLContext;
import org.jooq.Record1;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class ItemTagRepository {
    private final DSLContext context;
    private final TimeProvider timeProvider;

    public ItemTagRepository(DSLContext context, TimeProvider timeProvider) {
        this.context = context;
        this.timeProvider = timeProvider;
    }

    @Transactional
    public List<UUID> bulkStore(@NonNull List<ItemTagDto> itemTags) {
        if (itemTags.isEmpty()) {
            return List.of();
        }
        List<EhrItemTagRecord> newTags = itemTags.stream().filter(tag -> tag.getId() == null).map(this::newRecordForTag).toList();
        Map<UUID, ItemTagDto> existingTagsById = itemTags.stream().filter(tag -> tag.getId() != null).map(tag -> new AbstractMap.SimpleImmutableEntry<UUID, ItemTagDto>(tag.getId(), (ItemTagDto)tag)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        List<EhrItemTagRecord> existingTags = this.context.selectFrom((TableLike)EhrItemTag.EHR_ITEM_TAG).where(EhrItemTag.EHR_ITEM_TAG.ID.in(existingTagsById.keySet())).stream().map(dbRecord -> {
            ItemTagDto itemTag = (ItemTagDto)existingTagsById.remove(dbRecord.getId());
            this.mapItemTag(itemTag, (EhrItemTagRecord)dbRecord);
            return dbRecord;
        }).toList();
        if (!existingTagsById.isEmpty()) {
            throw new ObjectNotFoundException(ItemTagDto.class.getSimpleName(), "ItemTag(s) with ID(s) %s not found".formatted(existingTagsById.keySet()));
        }
        this.bulkInsert(newTags);
        this.context.batchUpdate(existingTags).execute();
        Iterator<EhrItemTagRecord> it = newTags.iterator();
        return itemTags.stream().map(t -> Optional.of(t).map(ItemTagDto::getId).orElseGet(() -> ((EhrItemTagRecord)it.next()).getId())).toList();
    }

    @Transactional
    public Collection<ItemTagDto> findForOwnerAndTarget(@NonNull UUID ownerId, @NonNull UUID targetVoId, @NonNull ItemTagDto.ItemTagRMType targetType, @NonNull Collection<UUID> ids, @NonNull Collection<String> keys) {
        SelectConditionStep query = this.context.select((SelectField)EhrItemTag.EHR_ITEM_TAG).from((TableLike)EhrItemTag.EHR_ITEM_TAG).where(EhrItemTag.EHR_ITEM_TAG.EHR_ID.eq((Object)ownerId)).and(EhrItemTag.EHR_ITEM_TAG.TARGET_TYPE.eq((Object)ItemTagRepository.itemTargetTypeToDbEnum(targetType))).and(EhrItemTag.EHR_ITEM_TAG.TARGET_VO_ID.eq((Object)targetVoId));
        if (!ids.isEmpty()) {
            query = query.and(EhrItemTag.EHR_ITEM_TAG.ID.in(ids));
        }
        if (!keys.isEmpty()) {
            query = query.and(EhrItemTag.EHR_ITEM_TAG.KEY.in(keys));
        }
        return query.fetch().map(ItemTagRepository::recordAsItemTag);
    }

    @Transactional
    public int bulkDelete(@NonNull UUID ownerId, @NonNull UUID targetVoId, @NonNull ItemTagDto.ItemTagRMType targetType, @NonNull Collection<UUID> ids) {
        if (ids.isEmpty()) {
            return 0;
        }
        return this.context.delete((Table)EhrItemTag.EHR_ITEM_TAG).where(EhrItemTag.EHR_ITEM_TAG.EHR_ID.eq((Object)ownerId)).and(EhrItemTag.EHR_ITEM_TAG.TARGET_TYPE.eq((Object)ItemTagRepository.itemTargetTypeToDbEnum(targetType))).and(EhrItemTag.EHR_ITEM_TAG.TARGET_VO_ID.eq((Object)targetVoId)).and(EhrItemTag.EHR_ITEM_TAG.ID.in(ids)).execute();
    }

    @Transactional
    public void adminDelete(UUID targetId, ItemTagDto.ItemTagRMType targetType) {
        this.context.delete((Table)EhrItemTag.EHR_ITEM_TAG).where(EhrItemTag.EHR_ITEM_TAG.TARGET_VO_ID.eq((Object)targetId)).and(EhrItemTag.EHR_ITEM_TAG.TARGET_TYPE.eq((Object)ItemTagRepository.itemTargetTypeToDbEnum(targetType))).execute();
    }

    @Transactional
    public void adminDeleteAll(UUID ehrId) {
        this.context.delete((Table)EhrItemTag.EHR_ITEM_TAG).where(EhrItemTag.EHR_ITEM_TAG.EHR_ID.eq((Object)ehrId)).execute();
    }

    private void bulkInsert(List<EhrItemTagRecord> records) {
        if (records.isEmpty()) {
            return;
        }
        try {
            RepositoryHelper.executeBulkInsert(this.context.dsl(), records.stream(), EhrItemTag.EHR_ITEM_TAG);
        }
        catch (DataIntegrityViolationException e) {
            String[] details = e.getMessage().split("[(|)]");
            throw new ObjectNotFoundException("EHR", "EHR with id '%s' does not exist".formatted(details[details.length - 2]));
        }
    }

    private EhrItemTagRecord newRecordForTag(ItemTagDto itemTag) {
        EhrItemTagRecord itemTagRecord = (EhrItemTagRecord)this.context.newRecord((Table)EhrItemTag.EHR_ITEM_TAG);
        this.mapItemTag(itemTag, itemTagRecord);
        itemTagRecord.setCreationDate(this.timeProvider.getNow());
        return itemTagRecord;
    }

    private void mapItemTag(ItemTagDto itemTag, EhrItemTagRecord itemTagRecord) {
        itemTagRecord.setId(Optional.ofNullable(itemTag.getId()).orElseGet(UuidGenerator::randomUUID));
        itemTagRecord.setEhrId(itemTag.getOwnerId());
        itemTagRecord.setTargetVoId(itemTag.getTarget());
        itemTagRecord.setTargetType(ItemTagRepository.itemTargetTypeToDbEnum(itemTag.getTargetType()));
        itemTagRecord.setKey(itemTag.getKey());
        itemTagRecord.setValue(itemTag.getValue());
        itemTagRecord.setTargetPath(itemTag.getTargetPath());
        itemTagRecord.setSysPeriodLower(this.timeProvider.getNow());
    }

    private static ItemTagDto recordAsItemTag(Record1<EhrItemTagRecord> dbRecord) {
        EhrItemTagRecord itemTagRecord = (EhrItemTagRecord)dbRecord.component1();
        return new ItemTagDto(itemTagRecord.getId(), itemTagRecord.getEhrId(), itemTagRecord.getTargetVoId(), ItemTagRepository.dbEnumToTargetType(itemTagRecord.getTargetType()), itemTagRecord.getTargetPath(), itemTagRecord.getKey(), itemTagRecord.getValue());
    }

    @Nonnull
    private static ItemTagDto.ItemTagRMType dbEnumToTargetType(EhrItemTagTargetType dbEnum) {
        return switch (dbEnum) {
            default -> throw new MatchException(null, null);
            case EhrItemTagTargetType.ehr_status -> ItemTagDto.ItemTagRMType.EHR_STATUS;
            case EhrItemTagTargetType.composition -> ItemTagDto.ItemTagRMType.COMPOSITION;
        };
    }

    private static EhrItemTagTargetType itemTargetTypeToDbEnum(ItemTagDto.ItemTagRMType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ItemTagDto.ItemTagRMType.EHR_STATUS -> EhrItemTagTargetType.ehr_status;
            case ItemTagDto.ItemTagRMType.COMPOSITION -> EhrItemTagTargetType.composition;
        };
    }
}

