/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.nedap.archie.query.RMPathQuery;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.generic.AuditDetails;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.rmobjectvalidator.APathQueryCache;
import com.nedap.archie.rmobjectvalidator.RMObjectValidationMessage;
import com.nedap.archie.rmobjectvalidator.RMObjectValidationMessageType;
import com.nedap.archie.rmobjectvalidator.RMObjectValidator;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.dto.EhrStatusDto;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.UnprocessableEntityException;
import org.ehrbase.api.exception.ValidationException;
import org.ehrbase.api.service.ValidationService;
import org.ehrbase.openehr.sdk.response.dto.ContributionCreateDto;
import org.ehrbase.openehr.sdk.terminology.openehr.TerminologyService;
import org.ehrbase.openehr.sdk.validation.CompositionValidator;
import org.ehrbase.openehr.sdk.validation.ConfigurableRMObjectValidator;
import org.ehrbase.openehr.sdk.validation.ConstraintViolationException;
import org.ehrbase.openehr.sdk.validation.terminology.ExternalTerminologyValidation;
import org.ehrbase.openehr.sdk.validation.terminology.ItemStructureVisitor;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplate;
import org.ehrbase.service.KnowledgeCacheServiceImp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ValidationServiceImp
implements ValidationService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Pattern NAMESPACE_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9-_:/&+?]*");
    private final KnowledgeCacheServiceImp knowledgeCacheService;
    private final TerminologyService terminologyService;
    private final ThreadLocal<CompositionValidator> compositionValidator;
    private final Map<String, RMPathQuery> rmPathQueryCache = new ConcurrentHashMap<String, RMPathQuery>();

    public ValidationServiceImp(KnowledgeCacheServiceImp knowledgeCacheService, TerminologyService terminologyService, ServerConfig serverConfig, ObjectProvider<ExternalTerminologyValidation> objectProvider, @Value(value="${cache.validation.useSharedRMPathQueryCache:true}") boolean sharedAqlQueryCache) {
        APathQueryCache delegator;
        this.knowledgeCacheService = knowledgeCacheService;
        this.terminologyService = terminologyService;
        boolean disableStrictValidation = serverConfig.isDisableStrictValidation();
        if (disableStrictValidation) {
            this.logger.warn("Disabling strict invariant validation. Caution is advised.");
        }
        if (sharedAqlQueryCache) {
            delegator = new APathQueryCache(){

                public RMPathQuery getApathQuery(String query) {
                    return ValidationServiceImp.this.rmPathQueryCache.computeIfAbsent(query, RMPathQuery::new);
                }
            };
        } else {
            this.logger.warn("shared RMPathQueryCache is disabled");
            delegator = null;
        }
        this.compositionValidator = ThreadLocal.withInitial(() -> ValidationServiceImp.createCompositionValidator(objectProvider, disableStrictValidation, delegator));
    }

    private static CompositionValidator createCompositionValidator(ObjectProvider<ExternalTerminologyValidation> objectProvider, boolean disableStrictValidation, APathQueryCache delegator) {
        CompositionValidator validator = new CompositionValidator();
        objectProvider.ifAvailable(arg_0 -> ((CompositionValidator)validator).setExternalTerminologyValidation(arg_0));
        validator.setRunInvariantChecks(!disableStrictValidation);
        ValidationServiceImp.setSharedAPathQueryCache(validator, delegator);
        return validator;
    }

    private static void setSharedAPathQueryCache(CompositionValidator validator, APathQueryCache delegator) {
        if (delegator == null) {
            return;
        }
        try {
            Field queryCacheField = RMObjectValidator.class.getDeclaredField("queryCache");
            queryCacheField.setAccessible(true);
            queryCacheField.set(validator.getRmObjectValidator(), delegator);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new InternalServerException("Failed to inject shared RMPathQuery cache", (Throwable)e);
        }
    }

    public void check(Composition composition) {
        ValidationServiceImp.compositionMandatoryProperty(composition.getName(), "name");
        ValidationServiceImp.compositionMandatoryProperty(composition.getArchetypeNodeId(), "archetype_node_id");
        ValidationServiceImp.compositionMandatoryProperty(composition.getLanguage(), "language");
        ValidationServiceImp.compositionMandatoryProperty(composition.getCategory(), "category");
        ValidationServiceImp.compositionMandatoryProperty(composition.getComposer(), "composer");
        ValidationServiceImp.compositionMandatoryProperty(composition.getArchetypeDetails(), "archetype details");
        ValidationServiceImp.compositionMandatoryProperty(composition.getArchetypeDetails().getTemplateId(), "archetype details/template_id");
        String templateID = composition.getArchetypeDetails().getTemplateId().getValue();
        this.check(templateID, composition);
        this.logger.debug("Validated Composition against WebTemplate[{}]", (Object)templateID);
    }

    private void check(String templateID, Composition composition) {
        WebTemplate webTemplate;
        try {
            webTemplate = this.knowledgeCacheService.getQueryOptMetaData(templateID);
        }
        catch (IllegalArgumentException e) {
            throw new UnprocessableEntityException(e.getMessage());
        }
        List violations = this.compositionValidator.get().validate(composition, webTemplate);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
        try {
            ItemStructureVisitor itemStructureVisitor = new ItemStructureVisitor(this.terminologyService);
            itemStructureVisitor.validate(composition);
        }
        catch (ReflectiveOperationException e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    private static void compositionMandatoryProperty(Object value, String attribute) {
        if (value == null) {
            throw new ValidationException("Composition missing mandatory attribute: %s".formatted(attribute));
        }
    }

    public void check(@Nonnull EhrStatusDto ehrStatus) {
        ConfigurableRMObjectValidator rmObjectValidator = this.compositionValidator.get().getRmObjectValidator();
        List validationIssues = Stream.of(ValidationServiceImp.require(ehrStatus.type(), "/subject", "subject", ehrStatus.subject()), ValidationServiceImp.require(ehrStatus.type(), "/is_queryable", "is_queryable", ehrStatus.isQueryable()), ValidationServiceImp.require(ehrStatus.type(), "/is_modifiable", "is_modifiable", ehrStatus.isModifiable()), ValidationServiceImp.validate((RMObjectValidator)rmObjectValidator, "/uid", ehrStatus.uid()), ValidationServiceImp.validate((RMObjectValidator)rmObjectValidator, "/name", ehrStatus.name()), ValidationServiceImp.validate((RMObjectValidator)rmObjectValidator, "/subject", ehrStatus.subject()), ValidationServiceImp.validate((RMObjectValidator)rmObjectValidator, "/archetype_details", ehrStatus.archetypeDetails()), ValidationServiceImp.validate((RMObjectValidator)rmObjectValidator, "/feeder_audit", ehrStatus.feederAudit()), ValidationServiceImp.validate((RMObjectValidator)rmObjectValidator, "/other_details", ehrStatus.otherDetails()), ValidationServiceImp.matches(ehrStatus.type(), "/subject/external_ref/namespace", "namespace", NAMESPACE_PATTERN, Optional.ofNullable(ehrStatus.subject()).map(PartyProxy::getExternalRef).map(ObjectRef::getNamespace))).flatMap(Collection::stream).toList();
        if (!validationIssues.isEmpty()) {
            throw new ValidationException(validationIssues.stream().map(Objects::toString).collect(Collectors.joining("\n")));
        }
    }

    public void check(ContributionCreateDto contribution) {
        ConfigurableRMObjectValidator rmObjectValidator = this.compositionValidator.get().getRmObjectValidator();
        ArrayList<RMObjectValidationMessage> messages = new ArrayList<RMObjectValidationMessage>();
        Optional.ofNullable(contribution.getAudit()).ifPresent(arg_0 -> ValidationServiceImp.lambda$check$2(messages, (RMObjectValidator)rmObjectValidator, arg_0));
        if (CollectionUtils.isEmpty((Collection)contribution.getVersions())) {
            messages.add(new RMObjectValidationMessage("/versions", null, null, null, "Versions must not be empty", RMObjectValidationMessageType.CARDINALITY_MISMATCH));
        } else {
            contribution.getVersions().stream().map(v -> {
                ValidationServiceImp.reject(messages, "/version/contribution", "contribution", v.getContribution());
                return v;
            }).map(arg_0 -> ((RMObjectValidator)rmObjectValidator).validate(arg_0)).flatMap(Collection::stream).filter(m -> {
                String path = m.getPath();
                return !path.equals("/commit_audit/time_committed") && !path.startsWith("/data") && !path.startsWith("/contribution") && (!path.startsWith("/uid") || m.getType() != RMObjectValidationMessageType.REQUIRED);
            }).forEach(messages::add);
        }
        if (!messages.isEmpty()) {
            String messageStr = messages.stream().map(Object::toString).collect(Collectors.joining("\n"));
            throw new ValidationException(messageStr);
        }
    }

    private static List<RMObjectValidationMessage> validate(RMObjectValidator rmObjectValidator, String path, Object value) {
        return Optional.ofNullable(value).map(arg_0 -> ((RMObjectValidator)rmObjectValidator).validate(arg_0)).stream().flatMap(Collection::stream).map(msg -> new RMObjectValidationMessage("%s%s".formatted(path, msg.getPath()), msg.getArchetypeId(), msg.getArchetypePath(), msg.getHumanReadableArchetypePath(), msg.getMessage(), msg.getType())).toList();
    }

    private static List<RMObjectValidationMessage> require(String type, String path, String attr, Object value) {
        if (value == null) {
            return List.of(new RMObjectValidationMessage(path, null, null, path, "Attribute %s of class %s does not match existence 1..1".formatted(attr, type), RMObjectValidationMessageType.REQUIRED));
        }
        return List.of();
    }

    private static List<RMObjectValidationMessage> matches(String type, String path, String attr, Pattern pattern, Optional<String> value) {
        boolean matches = value.map(v -> pattern.matcher((CharSequence)v).matches()).orElse(true);
        if (!matches) {
            return List.of(new RMObjectValidationMessage(path, null, null, path, "Invariant %s of class %s does not match pattern [%s]".formatted(attr, type, pattern.pattern()), RMObjectValidationMessageType.INVARIANT_ERROR));
        }
        return List.of();
    }

    private static void reject(List<RMObjectValidationMessage> messages, String path, String attr, Object mustBeNull) {
        if (mustBeNull != null) {
            messages.add(new RMObjectValidationMessage(path, null, null, path, "Attribute %s must not be set".formatted(attr), RMObjectValidationMessageType.CARDINALITY_MISMATCH));
        }
    }

    private static /* synthetic */ void lambda$check$2(List messages, RMObjectValidator rmObjectValidator, AuditDetails ad) {
        ValidationServiceImp.reject(messages, "/audit/time_committed", "time_committed", ad.getTimeCommitted());
        rmObjectValidator.validate((Object)ad).stream().filter(m -> !m.getPath().equals("/time_committed")).forEach(messages::add);
    }
}

