/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.repository;

import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.changecontrol.OriginalVersion;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rm.ehr.VersionedEhrStatus;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.time.OffsetDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.ehrbase.api.service.SystemService;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.enums.ContributionChangeType;
import org.ehrbase.jooq.pg.tables.Ehr;
import org.ehrbase.jooq.pg.tables.records.EhrRecord;
import org.ehrbase.jooq.pg.tables.records.EhrStatusDataHistoryRecord;
import org.ehrbase.jooq.pg.tables.records.EhrStatusDataRecord;
import org.ehrbase.jooq.pg.tables.records.EhrStatusVersionHistoryRecord;
import org.ehrbase.jooq.pg.tables.records.EhrStatusVersionRecord;
import org.ehrbase.openehr.dbformat.RmAttributeAlias;
import org.ehrbase.repository.AbstractVersionedObjectRepository;
import org.ehrbase.repository.AuditDetailsTargetType;
import org.ehrbase.repository.ContributionRepository;
import org.ehrbase.service.TimeProvider;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record1;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class EhrRepository
extends AbstractVersionedObjectRepository<EhrStatusVersionRecord, EhrStatusDataRecord, EhrStatusVersionHistoryRecord, EhrStatusDataHistoryRecord, EhrStatus> {
    public static final String[] IS_MODIFIABLE_JSON_PATH = RmAttributeAlias.rmToJsonPathParts((String)"is_modifiable");
    public static final String[] SUBJECT_ID_JSON_PATH = RmAttributeAlias.rmToJsonPathParts((String)"subject/external_ref/id/value");
    public static final String[] SUBJECT_NAMESPACE_JSON_PATH = RmAttributeAlias.rmToJsonPathParts((String)"subject/external_ref/namespace");

    public EhrRepository(DSLContext context, ContributionRepository contributionRepository, SystemService systemService, TimeProvider timeProvider) {
        super(AuditDetailsTargetType.EHR_STATUS, Tables.EHR_STATUS_VERSION, Tables.EHR_STATUS_DATA, Tables.EHR_STATUS_VERSION_HISTORY, Tables.EHR_STATUS_DATA_HISTORY, context, contributionRepository, systemService, timeProvider);
    }

    @Override
    protected List<TableField<EhrStatusVersionRecord, ?>> getVersionDataJoinFields() {
        return List.of(Tables.EHR_STATUS_VERSION.EHR_ID);
    }

    @Transactional
    public void commit(UUID ehrId, EhrStatus status, @Nullable UUID contributionId, @Nullable UUID auditId) {
        EhrRecord ehrRecord = (EhrRecord)this.context.newRecord((Table)Ehr.EHR_);
        ehrRecord.setId(ehrId);
        ehrRecord.setCreationDate(this.timeProvider.getNow());
        ehrRecord.store();
        this.commitHead(ehrId, (Locatable)status, contributionId, auditId, ContributionChangeType.creation, r -> {}, r -> r.setEhrId(ehrId));
    }

    @Override
    public boolean hasEhr(UUID ehrId) {
        return super.hasEhr(ehrId);
    }

    public Boolean fetchIsModifiable(UUID ehrId) {
        return this.fromJoinedVersionData(this.context.select((SelectField)this.jsonDataField(this.tables.dataHead(), IS_MODIFIABLE_JSON_PATH).cast(Boolean.class)), true).where(this.singleEhrStatusCondition(ehrId, this.tables.versionHead())).and(this.dataRootCondition(this.tables.dataHead())).fetchOptional().map(Record1::value1).orElse(null);
    }

    public Optional<UUID> findBySubject(String subjectId, String nameSpace) {
        return this.fromJoinedVersionData(this.context.select(this.field(EhrRepository.VERSION_PROTOTYPE.EHR_ID)), true).where(this.subjectCondition(subjectId, nameSpace, this.tables.dataHead())).and(this.dataRootCondition(this.tables.dataHead())).fetchOptional().map(Record1::value1);
    }

    Condition subjectCondition(String subjectId, String nameSpace, Table<EhrStatusDataRecord> dataTable) {
        return this.dataRootCondition(dataTable).and(this.jsonDataField(dataTable, SUBJECT_ID_JSON_PATH).eq((Object)subjectId)).and(this.jsonDataField(dataTable, SUBJECT_NAMESPACE_JSON_PATH).eq((Object)nameSpace));
    }

    public Optional<ObjectVersionId> findVersionByTime(UUID ehrId, OffsetDateTime time) {
        return this.findVersionByTime(this.singleEhrStatusCondition(ehrId, this.tables.versionHead()), this.singleEhrStatusCondition(ehrId, this.tables.versionHistory()), time);
    }

    public Optional<ObjectVersionId> findLatestVersion(UUID ehrId) {
        return this.context.select(this.field(EhrRepository.VERSION_PROTOTYPE.VO_ID), this.field(EhrRepository.VERSION_PROTOTYPE.SYS_VERSION)).from(this.tables.versionHead()).where(this.singleEhrStatusCondition(ehrId, this.tables.versionHead())).fetchOptional().map(r -> EhrRepository.buildObjectVersionId((UUID)r.value1(), (Integer)r.value2(), this.systemService));
    }

    public Optional<EhrStatus> findHead(UUID ehrId) {
        return this.findHead(this.singleEhrStatusCondition(ehrId, this.tables.dataHead()));
    }

    @Override
    protected boolean isDeleted(Condition condition, Condition historyCondition, Integer version) {
        return false;
    }

    public Optional<OriginalVersion<EhrStatus>> getOriginalVersionStatus(UUID ehrId, UUID versionedObjectUid, int version) {
        return this.getOriginalVersion(this.singleEhrStatusCondition(ehrId, this.tables.versionHead()), this.singleEhrStatusCondition(ehrId, this.tables.versionHistory()), version).filter(e -> UUID.fromString(e.getUid().getRoot().getValue()).equals(versionedObjectUid));
    }

    public OffsetDateTime findEhrCreationTime(UUID ehrId) {
        return (OffsetDateTime)((Record1)this.context.select((SelectField)Tables.EHR_.CREATION_DATE).from((TableLike)Tables.EHR_).where(Tables.EHR_.ID.eq((Object)ehrId)).fetchOne()).value1();
    }

    public void adminDelete(UUID ehrId) {
        this.context.deleteFrom(this.tables.versionHead()).where(this.field(EhrRepository.VERSION_PROTOTYPE.EHR_ID).eq((Object)ehrId)).execute();
        this.context.deleteFrom(this.tables.versionHistory()).where(this.field(EhrRepository.VERSION_HISTORY_PROTOTYPE.EHR_ID).eq((Object)ehrId)).execute();
        this.context.deleteFrom((Table)Tables.EHR_).where(Tables.EHR_.ID.eq((Object)ehrId)).execute();
    }

    @Transactional
    public void update(UUID ehrId, EhrStatus ehrStatus, @Nullable UUID contributionId, @Nullable UUID auditId) {
        this.update(ehrId, ehrStatus, this.singleEhrStatusCondition(ehrId, this.tables.versionHead()), this.singleEhrStatusCondition(ehrId, this.tables.versionHistory()), contributionId, auditId, r -> {}, r -> r.setEhrId(ehrId), "No EHR_STATUS in ehr: %s".formatted(ehrId));
    }

    public Optional<VersionedEhrStatus> getVersionedEhrStatus(UUID ehrId) {
        return this.findRootRecordByVersion(this.singleEhrStatusCondition(ehrId, this.tables.versionHead()), this.singleEhrStatusCondition(ehrId, this.tables.versionHistory()), 1).map(root -> EhrRepository.recordToVersionedEhrStatus(ehrId, root));
    }

    private Condition singleEhrStatusCondition(UUID ehrId, Table<?> table) {
        return table.field((Field)EhrRepository.VERSION_PROTOTYPE.EHR_ID).eq((Object)ehrId);
    }

    @Override
    protected Class<EhrStatus> getLocatableClass() {
        return EhrStatus.class;
    }

    private static VersionedEhrStatus recordToVersionedEhrStatus(UUID ehrId, EhrStatusVersionHistoryRecord record) {
        VersionedEhrStatus versionedComposition = new VersionedEhrStatus();
        versionedComposition.setUid(new HierObjectId(record.getVoId().toString()));
        versionedComposition.setOwnerId(new ObjectRef((ObjectId)new HierObjectId(ehrId.toString()), "local", "ehr"));
        versionedComposition.setTimeCreated(new DvDateTime((TemporalAccessor)record.getSysPeriodLower()));
        return versionedComposition;
    }
}

