/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.repository;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.knowledge.TemplateMetaData;
import org.ehrbase.jooq.pg.tables.TemplateStore;
import org.ehrbase.jooq.pg.tables.records.TemplateStoreRecord;
import org.ehrbase.service.TimeProvider;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record1;
import org.jooq.Record3;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.openehr.schemas.v1.TemplateDocument;
import org.springframework.stereotype.Repository;

@Repository
public class TemplateStoreRepository {
    private final DSLContext context;
    private final TimeProvider timeProvider;

    public TemplateStoreRepository(DSLContext context, TimeProvider timeProvider) {
        this.context = context;
        this.timeProvider = timeProvider;
    }

    public void store(OPERATIONALTEMPLATE operationaltemplate) {
        TemplateStoreRecord templateStoreRecord = (TemplateStoreRecord)this.context.newRecord((Table)TemplateStore.TEMPLATE_STORE);
        TemplateStoreRepository.setTemplate(operationaltemplate, templateStoreRecord, rec -> rec.setId(UUID.randomUUID()));
        templateStoreRecord.setCreationTime(this.timeProvider.getNow());
        templateStoreRecord.store();
    }

    public void update(OPERATIONALTEMPLATE operationaltemplate) {
        String templateId = operationaltemplate.getTemplateId().getValue();
        TemplateStoreRecord templateStoreRecord = (TemplateStoreRecord)this.context.selectFrom((TableLike)TemplateStore.TEMPLATE_STORE).where(TemplateStore.TEMPLATE_STORE.TEMPLATE_ID.eq((Object)templateId)).fetchOptional().orElseThrow(() -> new ObjectNotFoundException("OPERATIONALTEMPLATE", "No template with id = %s".formatted(templateId)));
        TemplateStoreRepository.setTemplate(operationaltemplate, templateStoreRecord, rec -> rec.setId(rec.getId()));
        templateStoreRecord.setCreationTime(this.timeProvider.getNow());
        templateStoreRecord.update();
    }

    public List<TemplateMetaData> findAll() {
        return this.context.select((SelectField)TemplateStore.TEMPLATE_STORE.CONTENT, (SelectField)TemplateStore.TEMPLATE_STORE.CREATION_TIME, (SelectField)TemplateStore.TEMPLATE_STORE.ID).from((TableLike)TemplateStore.TEMPLATE_STORE).fetch().map(TemplateStoreRepository::buildMetadata);
    }

    public List<String> findAllTemplateIds() {
        return this.context.select((SelectField)TemplateStore.TEMPLATE_STORE.TEMPLATE_ID).from((TableLike)TemplateStore.TEMPLATE_STORE).fetch().map(Record1::value1);
    }

    private static TemplateMetaData buildMetadata(Record3<String, OffsetDateTime, UUID> r) {
        TemplateMetaData templateMetaData = new TemplateMetaData();
        templateMetaData.setOperationalTemplate(TemplateStoreRepository.buildOperationaltemplate((String)r.component1()));
        templateMetaData.setInternalId((UUID)r.component3());
        templateMetaData.setCreatedOn((OffsetDateTime)r.component2());
        return templateMetaData;
    }

    public void delete(String templateId) {
        int execute = this.context.deleteFrom((Table)TemplateStore.TEMPLATE_STORE).where(TemplateStore.TEMPLATE_STORE.TEMPLATE_ID.eq((Object)templateId)).execute();
        if (execute == 0) {
            throw new ObjectNotFoundException("OPERATIONALTEMPLATE", "No template with id = %s".formatted(templateId));
        }
    }

    public Optional<OPERATIONALTEMPLATE> findByTemplateId(String templateId) {
        return this.context.select((SelectField)TemplateStore.TEMPLATE_STORE.CONTENT).from((TableLike)TemplateStore.TEMPLATE_STORE).where(TemplateStore.TEMPLATE_STORE.TEMPLATE_ID.eq((Object)templateId)).fetchOptional().map(Record1::value1).map(TemplateStoreRepository::buildOperationaltemplate);
    }

    public Optional<String> findTemplateIdByUuid(UUID uuid) {
        return this.context.select((SelectField)TemplateStore.TEMPLATE_STORE.TEMPLATE_ID).from((TableLike)TemplateStore.TEMPLATE_STORE).where(TemplateStore.TEMPLATE_STORE.ID.eq((Object)uuid)).fetchOptional((Field)TemplateStore.TEMPLATE_STORE.TEMPLATE_ID);
    }

    public Optional<UUID> findUuidByTemplateId(String templateId) {
        return this.context.select((SelectField)TemplateStore.TEMPLATE_STORE.ID).from((TableLike)TemplateStore.TEMPLATE_STORE).where(TemplateStore.TEMPLATE_STORE.TEMPLATE_ID.eq((Object)templateId)).fetchOptional((Field)TemplateStore.TEMPLATE_STORE.ID);
    }

    private static OPERATIONALTEMPLATE buildOperationaltemplate(String content) {
        TemplateDocument document;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
        try {
            document = TemplateDocument.Factory.parse((InputStream)inputStream);
        }
        catch (IOException | XmlException e) {
            throw new InternalServerException(e.getMessage());
        }
        return document.getTemplate();
    }

    private static void setTemplate(OPERATIONALTEMPLATE template, TemplateStoreRecord templateStoreRecord, Consumer<TemplateStoreRecord> setId) {
        setId.accept(templateStoreRecord);
        templateStoreRecord.setTemplateId(template.getTemplateId().getValue());
        XmlOptions opts = new XmlOptions();
        opts.setSaveSyntheticDocumentElement(new QName("http://schemas.openehr.org/v1", "template"));
        templateStoreRecord.setContent(template.xmlText(opts));
    }
}

