/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.util;

import java.util.List;
import java.util.Optional;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplate;
import org.ehrbase.openehr.sdk.webtemplate.parser.OPTParser;
import org.openehr.schemas.v1.OBJECTID;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;

public class TemplateUtils {
    public static final List<String> UNSUPPORTED_RM_TYPES = List.of("ITEM_TABLE");

    private TemplateUtils() {
    }

    public static boolean isSupported(OPERATIONALTEMPLATE template) {
        WebTemplate webTemplate = new OPTParser(template).parse();
        return TemplateUtils.isSupported(webTemplate);
    }

    public static boolean isSupported(WebTemplate template) {
        return template.getTree().findMatching(node -> UNSUPPORTED_RM_TYPES.contains(node.getRmType())).isEmpty();
    }

    public static String getTemplateId(OPERATIONALTEMPLATE template) {
        if (template == null) {
            throw new IllegalArgumentException("Template must not be null");
        }
        return Optional.ofNullable(template.getTemplateId()).map(OBJECTID::getValue).orElseThrow(() -> new IllegalArgumentException("Template ID must not be null for the given template"));
    }
}

