/*
 * Decompiled with CFR 0.152.
 */
package org.eiichiro.ash;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.eiichiro.ash.Terminal;

public class Usage {
    private final String syntax;
    private Set<Option> options = new TreeSet<Option>(new Comparator<Option>(){

        @Override
        public int compare(Option o1, Option o2) {
            return o1.opt.compareTo(o2.opt);
        }
    });

    public Usage(String syntax) {
        this.syntax = syntax;
    }

    public String syntax() {
        return this.syntax;
    }

    public Set<Option> options() {
        return this.options;
    }

    public void option(String opt, boolean required, String description) {
        this.option(opt, null, required, description, null);
    }

    public void option(String opt, boolean required, String description, String arg) {
        this.option(opt, null, required, description, arg);
    }

    public void option(String opt, String longOpt, boolean required, String description) {
        this.option(opt, longOpt, required, description, null);
    }

    public void option(String opt, String longOpt, boolean required, String description, String arg) {
        Option[] opts = this.options.toArray(new Option[this.options.size()]);
        for (int i = 0; i < opts.length; ++i) {
            if ((opts[i].opt == null || !opts[i].opt.equals(opt)) && (opts[i].longOpt == null || !opts[i].longOpt.equals(longOpt))) continue;
            this.options.remove(opts[i]);
        }
        this.options.add(new Option(opt, longOpt, required, description, arg));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String usage = "usage: ";
        String string = usage + this.syntax;
        int tab = usage.length() + this.syntax.indexOf(" ") + 1;
        String padding = StringUtils.leftPad((String)"", (int)tab);
        int pos = this.wrap(string, 0);
        boolean end = false;
        while (!end) {
            if (pos == -1) {
                builder.append(StringUtils.stripEnd((String)string, null));
                end = true;
                continue;
            }
            builder.append(StringUtils.stripEnd((String)string.substring(0, pos), null)).append('\n');
            string = padding + string.substring(pos).trim();
            pos = this.wrap(string, tab);
        }
        if (!this.options.isEmpty()) {
            String lpad = StringUtils.leftPad((String)"", (int)1);
            String dpad = StringUtils.leftPad((String)"", (int)3);
            int max = 0;
            ArrayList<StringBuilder> opts = new ArrayList<StringBuilder>();
            Iterator<Option> iterator = this.options.iterator();
            while (iterator.hasNext()) {
                StringBuilder b = new StringBuilder();
                Option option = iterator.next();
                if (option.opt() == null || option.opt().isEmpty()) {
                    b.append(lpad).append("   --" + option.longOpt());
                } else {
                    b.append(lpad).append("-" + option.opt());
                    if (option.longOpt() != null && !option.longOpt().isEmpty()) {
                        b.append(",--" + option.longOpt());
                    }
                }
                if (option.arg() != null && !option.arg().isEmpty()) {
                    b.append(" <" + option.arg() + ">");
                }
                opts.add(b);
                if (b.length() <= max) continue;
                max = b.length();
            }
            iterator = this.options.iterator();
            int i = 0;
            tab = max + dpad.length();
            while (iterator.hasNext()) {
                StringBuilder b = (StringBuilder)opts.get(i);
                if (b.length() < max) {
                    b.append(StringUtils.leftPad((String)"", (int)(max - b.length())));
                }
                b.append(dpad);
                Option option = iterator.next();
                if (option.description() != null && !option.description().isEmpty()) {
                    b.append(option.description);
                }
                string = b.toString();
                pos = this.wrap(string, tab);
                end = false;
                while (!end) {
                    if (pos == -1) {
                        builder.append(StringUtils.stripEnd((String)string, null));
                        end = true;
                        continue;
                    }
                    builder.append(StringUtils.stripEnd((String)string.substring(0, pos), null)).append('\n');
                    string = StringUtils.leftPad((String)"", (int)tab) + string.substring(pos).trim();
                    pos = this.wrap(string, tab);
                }
                if (!iterator.hasNext()) continue;
                builder.append('\n');
            }
        }
        return builder.toString();
    }

    private int wrap(String string, int from) {
        int pos = -1;
        pos = string.indexOf(10, from);
        if (pos != -1 && pos <= Terminal.width) {
            return pos + 1;
        }
        if (string.length() <= Terminal.width) {
            return -1;
        }
        for (pos = Terminal.width; pos >= from; --pos) {
            if (string.charAt(pos) != ' ' && string.charAt(pos) != '\t') continue;
            return pos;
        }
        for (pos = Terminal.width + 1; pos <= string.length(); ++pos) {
            if (string.charAt(pos) != ' ' && string.charAt(pos) != '\t') continue;
            return pos;
        }
        return -1;
    }

    static class Option {
        private final String opt;
        private final String longOpt;
        private final boolean required;
        private final String description;
        private final String arg;

        private Option(String opt, String longOpt, boolean required, String description, String arg) {
            Preconditions.checkArgument((opt != null && !opt.isEmpty() ? 1 : 0) != 0, (Object)("Parameter 'opt' must not be [" + opt + "]"));
            this.opt = opt;
            this.longOpt = longOpt;
            this.required = required;
            this.description = description;
            this.arg = arg;
        }

        String opt() {
            return this.opt;
        }

        String longOpt() {
            return this.longOpt;
        }

        boolean required() {
            return this.required;
        }

        String description() {
            return this.description;
        }

        String arg() {
            return this.arg;
        }
    }
}

