/*
 * Decompiled with CFR 0.152.
 */
package org.eiichiro.ash;

import com.google.common.base.Preconditions;
import java.io.IOException;
import jline.console.ConsoleReader;
import org.eiichiro.reverb.lang.UncheckedException;

public class Console {
    private final ConsoleReader reader;

    public Console() {
        try {
            this.reader = new ConsoleReader();
        }
        catch (IOException e) {
            throw new UncheckedException((Exception)e);
        }
    }

    public void print(String string) {
        try {
            this.reader.print((CharSequence)string);
            this.reader.flush();
        }
        catch (IOException e) {
            throw new UncheckedException((Exception)e);
        }
    }

    public void println(String string) {
        try {
            this.reader.println((CharSequence)string);
            this.reader.flush();
        }
        catch (IOException e) {
            throw new UncheckedException((Exception)e);
        }
    }

    public void prompt(String prompt) {
        Preconditions.checkArgument((prompt != null && !prompt.isEmpty() ? 1 : 0) != 0, (Object)("Parameter 'prompt' must not be [" + prompt + "]"));
        this.reader.setPrompt(prompt);
    }

    public String prompt() {
        return this.reader.getPrompt();
    }

    public String readLine() {
        try {
            return this.reader.readLine();
        }
        catch (IOException e) {
            throw new UncheckedException((Exception)e);
        }
    }

    public ConsoleReader reader() {
        return this.reader;
    }
}

