/*
 * Decompiled with CFR 0.152.
 */
package org.eiichiro.gig.appengine;

import org.eiichiro.acidhouse.appengine.AppEngineStrongDatastoreSession;
import org.eiichiro.acidhouse.appengine.AppEngineTransaction;
import org.eiichiro.gig.appengine.GlobalTransactional;
import org.eiichiro.jaguar.inject.Inject;
import org.eiichiro.jaguar.interceptor.Around;
import org.eiichiro.jaguar.interceptor.Interceptor;
import org.eiichiro.reverb.reflection.Invocation;

@GlobalTransactional
@Interceptor
public class AppEngineGlobalTransactionalInterceptor {
    @Inject
    private AppEngineStrongDatastoreSession session;

    @Around
    public Object transact(Invocation<?> invocation) throws Throwable {
        AppEngineTransaction transaction = null;
        if (!this.session.isTransactional()) {
            transaction = this.session.beginTransaction();
        }
        try {
            Object result = invocation.proceed();
            if (transaction != null) {
                transaction.commit();
            }
            return result;
        }
        catch (Throwable t) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw t;
        }
    }
}

