/*
 * Decompiled with CFR 0.152.
 */
package org.eiichiro.gig.persistence;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import org.eiichiro.gig.persistence.PersistenceXMLProcessor;
import org.eiichiro.jaguar.Component;
import org.eiichiro.jaguar.inject.Name;
import org.eiichiro.jaguar.lifecycle.Constructed;
import org.eiichiro.jaguar.lifecycle.Passivated;
import org.eiichiro.jaguar.scope.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Name(value="org.eiichiro.gig.persistence.JPAEntityManagerFactory")
@Singleton
public class JPAEntityManagerFactoryComponent
extends Component<EntityManagerFactory> {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private List<String> persistenceUnits = new ArrayList<String>();
    private Map<String, EntityManagerFactory> factories = new ConcurrentHashMap<String, EntityManagerFactory>();

    @Constructed
    public void configure() {
        PersistenceXMLProcessor processor = new PersistenceXMLProcessor();
        processor.process();
        this.persistenceUnits = processor.persistenceUnits();
    }

    @Passivated
    public void close() {
        for (EntityManagerFactory factory : this.factories.values()) {
            factory.close();
        }
        this.persistenceUnits.clear();
    }

    public EntityManagerFactory instance() {
        if (!this.persistenceUnits.isEmpty()) {
            EntityManagerFactory factory = this.factories.get(this.persistenceUnits.get(0));
            if (factory == null) {
                try {
                    factory = Persistence.createEntityManagerFactory((String)this.persistenceUnits.get(0));
                    this.factories.put(this.persistenceUnits.get(0), factory);
                    this.logger.info("EntityManagerFactory for persistence unit [" + this.persistenceUnits.get(0) + "] created");
                }
                catch (PersistenceException e) {
                    this.logger.error("Failed to create EntityManagerFactory", (Throwable)e);
                }
            }
            return factory;
        }
        this.logger.warn("Cannot access to the database service in this application; Returned 'EntityManagerFactory' instance is null");
        return null;
    }

    public List<String> persistenceUnits() {
        return this.persistenceUnits;
    }
}

