/*
 * Decompiled with CFR 0.152.
 */
package org.eiichiro.gig.persistence;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.eiichiro.gig.Transactional;
import org.eiichiro.jaguar.inject.Inject;
import org.eiichiro.jaguar.interceptor.Around;
import org.eiichiro.jaguar.interceptor.Interceptor;
import org.eiichiro.jaguar.validation.Required;
import org.eiichiro.reverb.reflection.Invocation;

@Transactional
@Interceptor
public class JPATransactionalInterceptor {
    @Inject
    @Required
    private EntityManager manager;

    @Around
    public Object transact(Invocation<?> invocation) throws Throwable {
        EntityTransaction transaction = this.manager.getTransaction();
        if (!transaction.isActive()) {
            transaction.begin();
        }
        try {
            Object result = invocation.proceed();
            if (transaction.isActive()) {
                transaction.commit();
            }
            return result;
        }
        catch (Throwable t) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw t;
        }
    }
}

