/*
 * Decompiled with CFR 0.152.
 */
package org.eiichiro.gig.persistence;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceXMLProcessor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<String> persistenceUnits = new ArrayList<String>();

    public void process() {
        try {
            Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources("META-INF/persistence.xml");
            XMLInputFactory factory = XMLInputFactory.newInstance();
            ArrayList<String> persistenceUnits = new ArrayList<String>();
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                XMLStreamReader reader = factory.createXMLStreamReader(url.openStream());
                block3: while (reader.hasNext()) {
                    if (reader.next() != 1 || !reader.getName().getLocalPart().equals("persistence-unit")) continue;
                    for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        if (!reader.getAttributeLocalName(i).equals("name")) continue;
                        persistenceUnits.add(reader.getAttributeValue(i));
                        continue block3;
                    }
                }
            }
            this.persistenceUnits = persistenceUnits;
        }
        catch (Exception e) {
            this.logger.error("Failed to parse persistence.xml", (Throwable)e);
        }
    }

    public List<String> persistenceUnits() {
        return this.persistenceUnits;
    }
}

