/*
 * Decompiled with CFR 0.152.
 */
package org.eiichiro.gig.tools.modgen;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import javassist.CtClass;
import org.eiichiro.bootleg.CtClassClassResolver;
import org.eiichiro.bootleg.annotation.Endpoint;
import org.eiichiro.gig.Main;
import org.eiichiro.jaguar.Builtin;
import org.eiichiro.jaguar.Component;
import org.eiichiro.jaguar.Stereotype;
import org.eiichiro.jaguar.deployment.Deployment;
import org.eiichiro.jaguar.inject.Binding;
import org.eiichiro.jaguar.scope.Scope;
import org.eiichiro.reverb.lang.ClassResolver;

public class ModuleGenerator {
    private static final String TEMPLATE = "org/eiichiro/gig/tools/modgen/Module_.java.template";
    private static final String PACKAGE = "org.eiichiro.gig";
    private static final String FILENAME = "Module_.java";
    private static final String INDENT = "\t\t";
    private final File destination;

    public static void main(String[] args) {
        Main.main((String[])args);
        System.out.println("Starting 'modgen' tool");
        File destination = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-d") && !args[i].equals("--destination") || args.length <= i) continue;
            destination = new File(args[i + 1]);
        }
        if (destination == null) {
            System.err.println("Destination (-d <directory>) must be specified");
            ModuleGenerator.fail();
        }
        if (!destination.exists()) {
            System.err.println("Destination [" + destination + "] must exist");
            ModuleGenerator.fail();
        }
        ModuleGenerator generator = new ModuleGenerator(destination);
        generator.generate();
    }

    private ModuleGenerator(File destination) {
        this.destination = destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate() {
        File file;
        System.out.println("Destination is [" + this.destination + "]");
        GigMatcher matcher = new GigMatcher();
        try {
            CtClassClassResolver resolver = new CtClassClassResolver();
            System.out.println("Resolving classpath...");
            resolver.resolve((ClassResolver.Matcher)matcher);
        }
        catch (Exception e) {
            e.printStackTrace();
            ModuleGenerator.fail();
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        BufferedReader reader = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream(TEMPLATE)));
        StringBuilder template = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                template.append(line + '\n');
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ModuleGenerator.fail();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        File directory = new File(this.destination, PACKAGE.replace('.', File.separatorChar));
        if (!directory.exists() && !directory.mkdirs()) {
            System.err.println("Cannot create directory [" + directory + "]");
            ModuleGenerator.fail();
        }
        if ((file = new File(directory, FILENAME)).exists() && !file.delete()) {
            System.err.println("Cannot delete existing file [" + file + "]");
            ModuleGenerator.fail();
        }
        System.out.println("Packaging components...");
        String source = this.replace(template.toString(), matcher);
        OutputStreamWriter writer = null;
        try {
            System.out.println("Saving module file...");
            writer = new FileWriter(file);
            writer.write(source);
        }
        catch (IOException e) {
            e.printStackTrace();
            ModuleGenerator.fail();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {}
            }
        }
        System.out.println("Completed");
    }

    private static void fail() {
        System.err.println("Failed");
        System.exit(1);
    }

    private String replace(String source, GigMatcher matcher) {
        HashSet<String> components = new HashSet<String>();
        for (CtClass ctClass : matcher.components) {
            String name = ctClass.getName();
            if (components.contains(name)) continue;
            components.add(name);
            System.out.println("Added [" + name + "] to the components");
        }
        StringBuilder builder = new StringBuilder();
        String[] classes = components.toArray(new String[components.size()]);
        for (int i = 0; i < classes.length; ++i) {
            builder.append("\t\tcomponents.add(" + classes[i] + ".class);");
            if (i >= classes.length) continue;
            builder.append("\n");
        }
        return source.replace("${components}", builder);
    }

    private static class GigMatcher
    implements ClassResolver.Matcher<CtClass> {
        private Set<CtClass> components = new HashSet<CtClass>();

        private GigMatcher() {
        }

        public boolean matches(CtClass ctClass) {
            try {
                int modifiers = ctClass.getModifiers();
                if (!Modifier.isPublic(modifiers)) {
                    ctClass.detach();
                    return false;
                }
                if (ctClass.getAnnotation(Endpoint.class) != null) {
                    this.components.add(ctClass);
                    return false;
                }
                if (ctClass.isInterface() || Modifier.isAbstract(modifiers) || ctClass.hasAnnotation(Builtin.class)) {
                    ctClass.detach();
                    return false;
                }
                for (CtClass superclass = ctClass.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
                    if (!superclass.getName().equals(Component.class.getName())) continue;
                    this.components.add(ctClass);
                    return false;
                }
                for (Object object : ctClass.getAnnotations()) {
                    Class<? extends Annotation> annotationType = ((Annotation)object).annotationType();
                    if (!annotationType.isAnnotationPresent(Stereotype.class) && !annotationType.isAnnotationPresent(Deployment.class) && !annotationType.isAnnotationPresent(Binding.class) && !annotationType.isAnnotationPresent(Scope.class)) continue;
                    this.components.add(ctClass);
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ctClass.detach();
            return false;
        }
    }
}

