/*
 * Decompiled with CFR 0.152.
 */
package org.eiichiro.gig.tools.scaffold;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;

public class ScaffoldFile {
    private final String template;
    private final File directory;
    private final File file;
    private final Map<String, String> parameters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ScaffoldFile(String template, String directory, String file, Map<String, String> parameters) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        BufferedReader reader = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream(template)));
        StringBuilder builder = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                builder.append(line + '\n');
            }
            this.template = builder.toString();
        }
        finally {
            reader.close();
        }
        this.directory = new File(directory);
        this.file = new File(directory, file);
        this.parameters = parameters;
    }

    boolean exists() {
        return this.file.exists();
    }

    boolean delete() {
        return this.file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save() throws IOException {
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            throw new IOException("Cannot create directory [" + this.directory + "]");
        }
        String content = this.template;
        for (String key : this.parameters.keySet()) {
            content = content.replace(key, this.parameters.get(key));
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.file);
            writer.write(content);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    String path() {
        return this.file.getPath();
    }
}

