/*
 * Decompiled with CFR 0.152.
 */
package org.eiichiro.gig.tools.scaffold;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eiichiro.gig.Main;
import org.eiichiro.gig.tools.scaffold.ScaffoldFile;

public class ScaffoldGenerator {
    private static final String ENDPOINT_TEMPLATE = "org/eiichiro/gig/tools/scaffold/Endpoint.java.template";
    private static final String SERVICE_TEMPLATE = "org/eiichiro/gig/tools/scaffold/Service.java.template";
    private static final String ACIDHOUSE_REPOSITORY_TEMPLATE = "org/eiichiro/gig/tools/scaffold/AcidHouseRepository.java.template";
    private static final String JPA_REPOSITORY_TEMPLATE = "org/eiichiro/gig/tools/scaffold/JPARepository.java.template";
    private static final String INDEX_TEMPLATE = "org/eiichiro/gig/tools/scaffold/index.html";
    private static final String LIST_TEMPLATE = "org/eiichiro/gig/tools/scaffold/list.html";
    private static final String CREATE_TEMPLATE = "org/eiichiro/gig/tools/scaffold/create.html";
    private static final String SHOW_TEMPLATE = "org/eiichiro/gig/tools/scaffold/show.html";
    private static final String EDIT_TEMPLATE = "org/eiichiro/gig/tools/scaffold/edit.html";
    private static final String ENDPOINT_FILENAME = "Endpoint.java";
    private static final String SERVICE_FILENAME = "Service.java";
    private static final String REPOSITORY_FILENAME = "Repository.java";
    private static final String INDEX_FILENAME = "index.html";
    private static final String LIST_FILENAME = "list.html";
    private static final String CREATE_FILENAME = "create.html";
    private static final String SHOW_FILENAME = "show.html";
    private static final String EDIT_FILENAME = "edit.html";
    private static final String CONTENT_SNIPPET = "<div class=\"control-group\">\n<label class=\"control-label\" for=\"input-${field}\">${field}</label>\n<div class=\"controls\">\n<input type=\"text\" id=\"input-${field}\"${option}>\n</div>\n</div>";
    private static final String POST_SNIPPET = "${field}: $('#input-${field}').val()";
    private static final String DATA_SNIPPET = "$('#input-${field}').val(${entity.name}.${field});";
    private static final String FOCUS_SNIPPET = "$('#input-${field}').focus();";
    private EntityType type;
    private Class<?> entity;
    private File destination;
    private File war;

    public static void main(String[] args) {
        Main.main((String[])args);
        System.out.println("Starting 'scaffold' tool");
        Class<?> entity = null;
        File destination = null;
        File war = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-e") || args[i].equals("--entity")) {
                if (args.length <= i) continue;
                try {
                    entity = Class.forName(args[i + 1]);
                }
                catch (ClassNotFoundException e) {
                    System.err.println("Entity class [" + args[i + 1] + "] not found");
                    ScaffoldGenerator.fail();
                }
                continue;
            }
            if (args[i].equals("-d") || args[i].equals("--destination")) {
                if (args.length <= i) continue;
                destination = new File(args[i + 1]);
                continue;
            }
            if (!args[i].equals("-w") && !args[i].equals("--war") || args.length <= i) continue;
            war = new File(args[i + 1]);
        }
        if (entity == null) {
            System.err.println("Entity class (-e <class>) must be specified");
            ScaffoldGenerator.fail();
        }
        HashSet<String> annotations = new HashSet<String>();
        for (Annotation annotation : entity.getAnnotations()) {
            annotations.add(annotation.annotationType().getName());
        }
        EntityType type = null;
        if (annotations.contains("org.eiichiro.acidhouse.Entity")) {
            type = EntityType.ACIDHOUSE;
        } else if (annotations.contains("javax.persistence.Entity")) {
            type = EntityType.JPA;
        } else {
            System.err.println("Entity class must be annotated with @Entity");
            ScaffoldGenerator.fail();
        }
        if (destination == null) {
            System.err.println("Destination (-d <directory>) must be specified");
            ScaffoldGenerator.fail();
        }
        if (!destination.exists()) {
            System.err.println("Destination [" + destination + "] must exist");
            ScaffoldGenerator.fail();
        }
        if (war == null) {
            System.err.println("WAR directory (-w <directory>) must be specified");
            ScaffoldGenerator.fail();
        }
        if (!war.exists()) {
            System.err.println("WAR directory [" + war + "] must exist");
            ScaffoldGenerator.fail();
        }
        ScaffoldGenerator generator = new ScaffoldGenerator(type, entity, destination, war);
        generator.generate();
    }

    private ScaffoldGenerator(EntityType type, Class<?> entity, File destination, File war) {
        this.type = type;
        this.entity = entity;
        this.destination = destination;
        this.war = war;
    }

    private void generate() {
        System.out.println("Entity type is [" + (Object)((Object)this.type) + "]");
        System.out.println("Entity class is [" + this.entity.getName() + "]");
        System.out.println("Destination is [" + this.destination + "]");
        System.out.println("Web application directory is [" + this.war + "]");
        System.out.println("Constructing parameters...");
        String entityPackage = this.entity.getPackage().getName();
        String entityClass = this.entity.getSimpleName();
        String entityName = entityClass.toLowerCase();
        Field key = this.key(this.entity);
        if (key == null) {
            if (this.type == EntityType.ACIDHOUSE) {
                System.err.println("Entity key field must be annotated with @Key");
            } else {
                System.err.println("Entity key field must be annotated with @Id");
            }
            ScaffoldGenerator.fail();
        }
        Package keyPackage = key.getType().getPackage();
        String keyClass = key.getType().getSimpleName();
        String keyName = key.getName();
        String keyImport = "";
        if (keyPackage != null && !keyPackage.getName().equals("java.lang")) {
            keyImport = "\nimport " + keyPackage + ";\n";
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(key);
        for (Field field : this.entity.getDeclaredFields()) {
            if (field.equals(key)) continue;
            fields.add(field);
        }
        int i = 0;
        int size = fields.size();
        StringBuilder createHTMLContent = new StringBuilder();
        StringBuilder showHTMLContent = new StringBuilder();
        StringBuilder editHTMLContent = new StringBuilder();
        for (Field field : fields) {
            createHTMLContent.append(CONTENT_SNIPPET.replace("${option}", " placeholder=\"${field}\"").replace("${field}", field.getName()));
            showHTMLContent.append(CONTENT_SNIPPET.replace("${option}", " readonly").replace("${field}", field.getName()));
            if (++i == 1) {
                editHTMLContent.append(CONTENT_SNIPPET.replace("${option}", " readonly").replace("${field}", field.getName()));
            } else {
                editHTMLContent.append(CONTENT_SNIPPET.replace("${option}", "").replace("${field}", field.getName()));
            }
            if (i >= size) continue;
            createHTMLContent.append("\n");
            showHTMLContent.append("\n");
            editHTMLContent.append("\n");
        }
        i = 0;
        StringBuilder createHTMLPost = new StringBuilder();
        StringBuilder editHTMLPost = new StringBuilder();
        for (Field field : fields) {
            ++i;
            String snippet = POST_SNIPPET.replace("${field}", field.getName());
            createHTMLPost.append(snippet);
            editHTMLPost.append(snippet);
            if (i >= size) continue;
            createHTMLPost.append(", \n");
            editHTMLPost.append(", \n");
        }
        i = 0;
        StringBuilder showHTMLData = new StringBuilder();
        StringBuilder editHTMLData = new StringBuilder();
        for (Field field : fields) {
            ++i;
            String snippet = DATA_SNIPPET.replace("${field}", field.getName()).replace("${entity.name}", entityName);
            showHTMLData.append(snippet);
            editHTMLData.append(snippet);
            if (i >= size) continue;
            showHTMLData.append("\n");
            editHTMLData.append("\n");
        }
        StringBuilder createHTMLFocus = new StringBuilder();
        StringBuilder editHTMLFocus = new StringBuilder();
        if (size > 0) {
            createHTMLFocus.append(FOCUS_SNIPPET.replace("${field}", ((Field)fields.get(0)).getName()));
        }
        if (size > 1) {
            editHTMLFocus.append(FOCUS_SNIPPET.replace("${field}", ((Field)fields.get(1)).getName()));
        }
        System.out.println("Generating scaffold...");
        ScaffoldFile repository = null;
        ScaffoldFile service = null;
        ScaffoldFile endpoint = null;
        ScaffoldFile index = null;
        ScaffoldFile list = null;
        ScaffoldFile create = null;
        ScaffoldFile show = null;
        ScaffoldFile edit = null;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("${entity.package}", entityPackage);
        parameters.put("${entity.class}", entityClass);
        parameters.put("${entity.name}", entityName);
        parameters.put("${key.name}", keyName);
        parameters.put("${key.class}", keyClass);
        parameters.put("${key.import}", keyImport);
        parameters.put("${create.html.content}", createHTMLContent.toString());
        parameters.put("${show.html.content}", showHTMLContent.toString());
        parameters.put("${edit.html.content}", editHTMLContent.toString());
        parameters.put("${create.html.post}", createHTMLPost.toString());
        parameters.put("${edit.html.post}", editHTMLPost.toString());
        parameters.put("${show.html.data}", showHTMLData.toString());
        parameters.put("${edit.html.data}", editHTMLData.toString());
        parameters.put("${create.html.focus}", createHTMLFocus.toString());
        parameters.put("${edit.html.focus}", editHTMLFocus.toString());
        try {
            repository = new ScaffoldFile(this.type == EntityType.ACIDHOUSE ? ACIDHOUSE_REPOSITORY_TEMPLATE : JPA_REPOSITORY_TEMPLATE, new File(this.destination, entityPackage.replace('.', File.separatorChar)).toString(), entityClass + REPOSITORY_FILENAME, parameters);
            service = new ScaffoldFile(SERVICE_TEMPLATE, new File(this.destination, entityPackage.replace('.', File.separatorChar)).toString(), entityClass + SERVICE_FILENAME, parameters);
            endpoint = new ScaffoldFile(ENDPOINT_TEMPLATE, new File(this.destination, entityPackage.replace('.', File.separatorChar)).toString(), entityClass + ENDPOINT_FILENAME, parameters);
            index = new ScaffoldFile(INDEX_TEMPLATE, new File(this.war, entityName).toString(), INDEX_FILENAME, parameters);
            list = new ScaffoldFile(LIST_TEMPLATE, new File(this.war, entityName).toString(), LIST_FILENAME, parameters);
            create = new ScaffoldFile(CREATE_TEMPLATE, new File(this.war, entityName).toString(), CREATE_FILENAME, parameters);
            show = new ScaffoldFile(SHOW_TEMPLATE, new File(this.war, entityName).toString(), SHOW_FILENAME, parameters);
            edit = new ScaffoldFile(EDIT_TEMPLATE, new File(this.war, entityName).toString(), EDIT_FILENAME, parameters);
        }
        catch (IOException e) {
            e.printStackTrace();
            ScaffoldGenerator.fail();
        }
        if (repository.exists() && !repository.delete()) {
            System.err.println("Cannot delete existing file [" + repository.path() + "]");
            ScaffoldGenerator.fail();
        }
        if (service.exists() && !service.delete()) {
            System.err.println("Cannot delete existing file [" + service.path() + "]");
            ScaffoldGenerator.fail();
        }
        if (endpoint.exists() && !endpoint.delete()) {
            System.err.println("Cannot delete existing file [" + endpoint.path() + "]");
            ScaffoldGenerator.fail();
        }
        if (index.exists() && !index.delete()) {
            System.err.println("Cannot delete existing file [" + index.path() + "]");
            ScaffoldGenerator.fail();
        }
        if (list.exists() && !list.delete()) {
            System.err.println("Cannot delete existing file [" + list.path() + "]");
            ScaffoldGenerator.fail();
        }
        if (create.exists() && !create.delete()) {
            System.err.println("Cannot delete existing file [" + create.path() + "]");
            ScaffoldGenerator.fail();
        }
        if (show.exists() && !show.delete()) {
            System.err.println("Cannot delete existing file [" + show.path() + "]");
            ScaffoldGenerator.fail();
        }
        if (edit.exists() && !edit.delete()) {
            System.err.println("Cannot delete existing file [" + edit.path() + "]");
            ScaffoldGenerator.fail();
        }
        try {
            repository.save();
            System.out.println("CRUD Repository component [" + repository.path() + "] generated");
            service.save();
            System.out.println("CRUD Service component [" + service.path() + "] generated");
            endpoint.save();
            System.out.println("CRUD Web endpoint [" + endpoint.path() + "] generated");
            index.save();
            System.out.println("HTML [" + index.path() + "] generated");
            list.save();
            System.out.println("HTML [" + list.path() + "] generated");
            create.save();
            System.out.println("HTML [" + create.path() + "] generated");
            show.save();
            System.out.println("HTML [" + show.path() + "] generated");
            edit.save();
            System.out.println("HTML [" + edit.path() + "] generated");
        }
        catch (IOException e) {
            e.printStackTrace();
            ScaffoldGenerator.fail();
        }
        System.out.println("Completed");
    }

    private static void fail() {
        System.err.println("Failed");
        System.exit(1);
    }

    private Field key(Class<?> entity) {
        for (Field field : entity.getDeclaredFields()) {
            HashSet<String> annotations = new HashSet<String>();
            for (Annotation annotation : field.getAnnotations()) {
                annotations.add(annotation.annotationType().getName());
            }
            if ((this.type != EntityType.ACIDHOUSE || !annotations.contains("org.eiichiro.acidhouse.Key")) && (this.type != EntityType.JPA || !annotations.contains("javax.persistence.Id"))) continue;
            return field;
        }
        return null;
    }

    private static enum EntityType {
        ACIDHOUSE,
        JPA;

    }
}

