/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ejbca.cvc.AbstractSequence;
import org.ejbca.cvc.CVCObject;
import org.ejbca.cvc.CVCTagEnum;
import org.ejbca.cvc.exception.ConstructionException;

public abstract class AbstractArray
extends AbstractSequence {
    private static final long serialVersionUID = 1L;
    private final List<CVCObject> subfields = new ArrayList<CVCObject>();
    private final CVCTagEnum allowedField = this.getAllowedField();

    AbstractArray(CVCTagEnum type) {
        super(type);
    }

    @Override
    void addSubfield(CVCObject field) throws ConstructionException {
        if (field != null) {
            if (this.allowedField != field.getTag()) {
                throw new ConstructionException("Field " + (Object)((Object)field.getTag()) + " not allowed in " + this.getClass().getName());
            }
            field.setParent(this);
            this.subfields.add(field);
        }
    }

    protected abstract CVCTagEnum getAllowedField();

    @Override
    protected final CVCTagEnum[] getAllowedFields() {
        return new CVCTagEnum[]{this.getAllowedField()};
    }

    @Override
    protected final CVCObject getSubfield(CVCTagEnum fieldTag) throws NoSuchFieldException {
        throw new IllegalStateException("Not applicable to AbstractArray");
    }

    @Override
    protected final CVCObject getOptionalSubfield(CVCTagEnum tag) {
        throw new IllegalStateException("Not applicable to AbstractArray");
    }

    @Override
    protected Collection<CVCObject> getSubfields() {
        return new ArrayList<CVCObject>(this.subfields);
    }

    @Override
    protected List<CVCObject> getOrderedSubfields() {
        return new ArrayList<CVCObject>(this.subfields);
    }
}

