/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.util.HashMap;
import org.ejbca.cvc.CVCObjectIdentifiers;
import org.ejbca.cvc.OIDField;

public class AlgorithmUtil {
    private static HashMap<String, OIDField> algorithmMap = new HashMap();
    private static HashMap<String, String> conversionMap = new HashMap();

    public static OIDField getOIDField(String algorithmName) {
        OIDField oid = algorithmMap.get(AlgorithmUtil.convertAlgorithmNameToCVC(algorithmName));
        if (oid == null) {
            throw new IllegalArgumentException("Unsupported algorithmName: " + algorithmName);
        }
        return oid;
    }

    public static String convertAlgorithmNameToCVC(String algorithmName) {
        String name = conversionMap.get(algorithmName.toUpperCase());
        if (name != null) {
            return name;
        }
        return algorithmName.toUpperCase();
    }

    public static String getAlgorithmName(OIDField oid) {
        for (String key : algorithmMap.keySet()) {
            OIDField oidfield = algorithmMap.get(key);
            if (!oidfield.getValue().equals(oid.getValue())) continue;
            return key;
        }
        throw new IllegalArgumentException("Unknown OIDField: " + oid.getValue());
    }

    static {
        algorithmMap.put("SHA1WITHRSA", CVCObjectIdentifiers.id_TA_RSA_v1_5_SHA_1);
        algorithmMap.put("SHA256WITHRSA", CVCObjectIdentifiers.id_TA_RSA_v1_5_SHA_256);
        algorithmMap.put("SHA1WITHRSAANDMGF1", CVCObjectIdentifiers.id_TA_RSA_PSS_SHA_1);
        algorithmMap.put("SHA256WITHRSAANDMGF1", CVCObjectIdentifiers.id_TA_RSA_PSS_SHA_256);
        algorithmMap.put("SHA1WITHECDSA", CVCObjectIdentifiers.id_TA_ECDSA_SHA_1);
        algorithmMap.put("SHA224WITHECDSA", CVCObjectIdentifiers.id_TA_ECDSA_SHA_224);
        algorithmMap.put("SHA256WITHECDSA", CVCObjectIdentifiers.id_TA_ECDSA_SHA_256);
        conversionMap.put("SHA1WITHECDSA", "SHA1WITHECDSA");
        conversionMap.put("SHA224WITHECDSA", "SHA224WITHECDSA");
        conversionMap.put("SHA256WITHECDSA", "SHA256WITHECDSA");
    }
}

