/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.math.BigInteger;
import org.ejbca.cvc.AbstractDataField;
import org.ejbca.cvc.CVCTagEnum;
import org.ejbca.cvc.util.StringConverter;

public class ByteField
extends AbstractDataField {
    private static final long serialVersionUID = 1L;
    private byte[] data;
    private boolean showBitLength = false;

    ByteField(CVCTagEnum tag) {
        super(tag);
    }

    ByteField(CVCTagEnum tag, byte[] data) {
        this(tag, data, false);
    }

    ByteField(CVCTagEnum tag, byte[] data, boolean showBitLength) {
        super(tag);
        this.data = data;
        this.showBitLength = showBitLength;
    }

    public boolean isShowBitLength() {
        return this.showBitLength;
    }

    public void setShowBitLength(boolean showBitLength) {
        this.showBitLength = showBitLength;
    }

    public byte[] getData() {
        return this.data;
    }

    protected byte[] getEncoded() {
        return this.data;
    }

    protected String valueAsText() {
        String lenInfo = "";
        if (this.showBitLength) {
            int bitLength = 0;
            if (this.data != null) {
                BigInteger big = new BigInteger(1, this.data);
                bitLength = big.bitLength();
            }
            lenInfo = "[" + bitLength + "]  ";
        }
        return lenInfo + StringConverter.byteToHex(this.data);
    }
}

