/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import org.ejbca.cvc.AbstractSequence;
import org.ejbca.cvc.AccessRightAuthTerm;
import org.ejbca.cvc.AccessRightEnum;
import org.ejbca.cvc.AccessRightSignTermEnum;
import org.ejbca.cvc.AccessRights;
import org.ejbca.cvc.AuthorizationField;
import org.ejbca.cvc.AuthorizationRole;
import org.ejbca.cvc.AuthorizationRoleAuthTermEnum;
import org.ejbca.cvc.AuthorizationRoleEnum;
import org.ejbca.cvc.AuthorizationRoleSignTermEnum;
import org.ejbca.cvc.CVCObject;
import org.ejbca.cvc.CVCObjectIdentifiers;
import org.ejbca.cvc.CVCTagEnum;
import org.ejbca.cvc.OIDField;
import org.ejbca.cvc.exception.ConstructionException;

public class CVCAuthorizationTemplate
extends AbstractSequence {
    private static final long serialVersionUID = 1L;
    private static CVCTagEnum[] allowedFields = new CVCTagEnum[]{CVCTagEnum.OID, CVCTagEnum.ROLE_AND_ACCESS_RIGHTS};

    protected CVCTagEnum[] getAllowedFields() {
        return allowedFields;
    }

    CVCAuthorizationTemplate() {
        super(CVCTagEnum.HOLDER_AUTH_TEMPLATE);
    }

    void addSubfield(CVCObject field) throws ConstructionException {
        super.addSubfield(field);
        if (field instanceof AuthorizationField) {
            try {
                AuthorizationField authfield = (AuthorizationField)field;
                OIDField oid = (OIDField)this.getSubfield(CVCTagEnum.OID);
                authfield.fixEnumTypes(oid);
            }
            catch (NoSuchFieldException e) {
                throw new ConstructionException("Tried to add an AuthorizationField without an OID", e);
            }
        }
    }

    public CVCAuthorizationTemplate(AuthorizationRole role, AccessRights rights) throws ConstructionException {
        this();
        this.addSubfield(CVCAuthorizationTemplate.getOIDForEnums(role, rights));
        this.addSubfield(new AuthorizationField(role, rights));
    }

    public CVCAuthorizationTemplate(AuthorizationRoleEnum role, AccessRightEnum rights) throws ConstructionException {
        this((AuthorizationRole)role, (AccessRights)rights);
    }

    public static OIDField getOIDForEnums(AuthorizationRole role, AccessRights rights) {
        if (role instanceof AuthorizationRoleEnum && rights instanceof AccessRightEnum) {
            return CVCObjectIdentifiers.id_EAC_ePassport;
        }
        if (role instanceof AuthorizationRoleAuthTermEnum && rights instanceof AccessRightAuthTerm) {
            return CVCObjectIdentifiers.id_EAC_roles_AT;
        }
        if (role instanceof AuthorizationRoleSignTermEnum && rights instanceof AccessRightSignTermEnum) {
            return CVCObjectIdentifiers.id_EAC_roles_ST;
        }
        throw new IllegalArgumentException("Unsupported roles/rights type (or mismatch). Got role of type " + role.getClass().getSimpleName() + ", but rights of type " + rights.getClass().getSimpleName());
    }

    public String getObjectIdentifier() throws NoSuchFieldException {
        return ((OIDField)this.getSubfield(CVCTagEnum.OID)).getValue();
    }

    public AuthorizationField getAuthorizationField() throws NoSuchFieldException {
        return (AuthorizationField)this.getSubfield(CVCTagEnum.ROLE_AND_ACCESS_RIGHTS);
    }
}

