/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import org.ejbca.cvc.AbstractSequence;
import org.ejbca.cvc.AlgorithmUtil;
import org.ejbca.cvc.ByteField;
import org.ejbca.cvc.CVCTagEnum;
import org.ejbca.cvc.CVCertificateBody;
import org.ejbca.cvc.OIDField;
import org.ejbca.cvc.Signable;
import org.ejbca.cvc.exception.ConstructionException;
import org.ejbca.cvc.util.BCECUtil;

public class CVCertificate
extends AbstractSequence
implements Signable {
    private static final long serialVersionUID = 1L;
    private static CVCTagEnum[] allowedFields = new CVCTagEnum[]{CVCTagEnum.CERTIFICATE_BODY, CVCTagEnum.SIGNATURE};

    protected CVCTagEnum[] getAllowedFields() {
        return allowedFields;
    }

    CVCertificate() {
        super(CVCTagEnum.CV_CERTIFICATE);
    }

    public CVCertificate(CVCertificateBody body) throws ConstructionException {
        this();
        if (body == null) {
            throw new IllegalArgumentException("body is null");
        }
        this.addSubfield(body);
    }

    public void setSignature(byte[] signatureData) throws ConstructionException {
        this.addSubfield(new ByteField(CVCTagEnum.SIGNATURE, signatureData));
    }

    public CVCertificateBody getCertificateBody() throws NoSuchFieldException {
        return (CVCertificateBody)this.getSubfield(CVCTagEnum.CERTIFICATE_BODY);
    }

    public byte[] getSignature() throws NoSuchFieldException {
        return ((ByteField)this.getSubfield(CVCTagEnum.SIGNATURE)).getData();
    }

    public byte[] getTBS() throws ConstructionException {
        try {
            return this.getCertificateBody().getDEREncoded();
        }
        catch (IOException e) {
            throw new ConstructionException(e);
        }
        catch (NoSuchFieldException e) {
            throw new ConstructionException(e);
        }
    }

    public String toString() {
        return this.getAsText("");
    }

    public void verify(PublicKey key, String provider) throws CertificateException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        try {
            OIDField oid = this.getCertificateBody().getPublicKey().getObjectIdentifier();
            String algorithm = AlgorithmUtil.getAlgorithmName(oid);
            Signature sign = Signature.getInstance(algorithm, provider);
            sign.initVerify(key);
            sign.update(this.getTBS());
            byte[] sig = BCECUtil.convertCVCSigToX962(algorithm, this.getSignature());
            if (!sign.verify(sig)) {
                throw new SignatureException("Signature verification failed!");
            }
        }
        catch (NoSuchFieldException e) {
            throw new CertificateException("CV-Certificate is corrupt", e);
        }
        catch (ConstructionException e) {
            throw new CertificateException("CV-Certificate is corrupt", e);
        }
    }
}

