/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.util.Date;
import org.ejbca.cvc.AbstractSequence;
import org.ejbca.cvc.AccessRightEnum;
import org.ejbca.cvc.AccessRights;
import org.ejbca.cvc.AuthorizationRole;
import org.ejbca.cvc.AuthorizationRoleEnum;
import org.ejbca.cvc.CAReferenceField;
import org.ejbca.cvc.CVCAuthorizationTemplate;
import org.ejbca.cvc.CVCPublicKey;
import org.ejbca.cvc.CVCTagEnum;
import org.ejbca.cvc.DateField;
import org.ejbca.cvc.HolderReferenceField;
import org.ejbca.cvc.IntegerField;
import org.ejbca.cvc.exception.ConstructionException;

public class CVCertificateBody
extends AbstractSequence {
    private static final long serialVersionUID = 1L;
    private static CVCTagEnum[] allowedFields = new CVCTagEnum[]{CVCTagEnum.PROFILE_IDENTIFIER, CVCTagEnum.CA_REFERENCE, CVCTagEnum.PUBLIC_KEY, CVCTagEnum.HOLDER_REFERENCE, CVCTagEnum.HOLDER_AUTH_TEMPLATE, CVCTagEnum.EFFECTIVE_DATE, CVCTagEnum.EXPIRATION_DATE};

    protected CVCTagEnum[] getAllowedFields() {
        return allowedFields;
    }

    CVCertificateBody() {
        super(CVCTagEnum.CERTIFICATE_BODY);
    }

    public CVCertificateBody(CAReferenceField authorityReference, CVCPublicKey publicKey, HolderReferenceField holderReference) throws ConstructionException {
        this();
        if (publicKey == null) {
            throw new IllegalArgumentException("publicKey is null");
        }
        if (holderReference == null) {
            throw new IllegalArgumentException("holderReference is null");
        }
        this.addSubfield(new IntegerField(CVCTagEnum.PROFILE_IDENTIFIER, 0));
        this.addSubfield(authorityReference);
        this.addSubfield(publicKey);
        this.addSubfield(holderReference);
    }

    public CVCertificateBody(CAReferenceField authorityReference, CVCPublicKey publicKey, HolderReferenceField holderReference, AuthorizationRole authRole, AccessRights accessRight, Date validFrom, Date validTo) throws ConstructionException {
        this(authorityReference, publicKey, holderReference);
        if (authRole == null) {
            throw new IllegalArgumentException("authRole is null");
        }
        if (accessRight == null) {
            throw new IllegalArgumentException("accessRight is null");
        }
        if (validFrom == null) {
            throw new IllegalArgumentException("validFrom is null");
        }
        if (validTo == null) {
            throw new IllegalArgumentException("validTo is null");
        }
        this.addSubfield(new CVCAuthorizationTemplate(authRole, accessRight));
        this.addSubfield(new DateField(CVCTagEnum.EFFECTIVE_DATE, validFrom));
        this.addSubfield(new DateField(CVCTagEnum.EXPIRATION_DATE, validTo));
    }

    public CVCertificateBody(CAReferenceField authorityReference, CVCPublicKey publicKey, HolderReferenceField holderReference, AuthorizationRoleEnum authRole, AccessRightEnum accessRight, Date validFrom, Date validTo) throws ConstructionException {
        this(authorityReference, publicKey, holderReference, (AuthorizationRole)authRole, (AccessRights)accessRight, validFrom, validTo);
    }

    public CVCAuthorizationTemplate getAuthorizationTemplate() throws NoSuchFieldException {
        return (CVCAuthorizationTemplate)this.getSubfield(CVCTagEnum.HOLDER_AUTH_TEMPLATE);
    }

    public Date getValidFrom() throws NoSuchFieldException {
        return ((DateField)this.getSubfield(CVCTagEnum.EFFECTIVE_DATE)).getDate();
    }

    public Date getValidTo() throws NoSuchFieldException {
        return ((DateField)this.getSubfield(CVCTagEnum.EXPIRATION_DATE)).getDate();
    }

    public CAReferenceField getAuthorityReference() throws NoSuchFieldException {
        return (CAReferenceField)this.getOptionalSubfield(CVCTagEnum.CA_REFERENCE);
    }

    public CVCPublicKey getPublicKey() throws NoSuchFieldException {
        return (CVCPublicKey)this.getSubfield(CVCTagEnum.PUBLIC_KEY);
    }

    public HolderReferenceField getHolderReference() throws NoSuchFieldException {
        return (HolderReferenceField)this.getSubfield(CVCTagEnum.HOLDER_REFERENCE);
    }
}

