/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Calendar;
import java.util.Date;
import org.ejbca.cvc.AccessRightEnum;
import org.ejbca.cvc.AccessRights;
import org.ejbca.cvc.AlgorithmUtil;
import org.ejbca.cvc.AuthorizationRole;
import org.ejbca.cvc.AuthorizationRoleEnum;
import org.ejbca.cvc.CAReferenceField;
import org.ejbca.cvc.CVCAuthenticatedRequest;
import org.ejbca.cvc.CVCPublicKey;
import org.ejbca.cvc.CVCertificate;
import org.ejbca.cvc.CVCertificateBody;
import org.ejbca.cvc.HolderReferenceField;
import org.ejbca.cvc.KeyFactory;
import org.ejbca.cvc.exception.ConstructionException;
import org.ejbca.cvc.util.BCECUtil;

public final class CertificateGenerator {
    private CertificateGenerator() {
    }

    public static CVCertificate createTestCertificate(PublicKey publicKey, PrivateKey privateKey, CAReferenceField caRef, HolderReferenceField holderRef, String algorithm, AuthorizationRoleEnum role) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException, ConstructionException {
        Calendar cal1 = Calendar.getInstance();
        Date validFrom = cal1.getTime();
        Calendar cal2 = Calendar.getInstance();
        cal2.add(2, 3);
        Date validTo = cal2.getTime();
        return CertificateGenerator.createCertificate(publicKey, privateKey, algorithm, caRef, holderRef, role, AccessRightEnum.READ_ACCESS_DG3_AND_DG4, validFrom, validTo, "BC");
    }

    public static CVCertificate createCertificate(PublicKey publicKey, PrivateKey signerKey, String algorithmName, CAReferenceField caRef, HolderReferenceField holderRef, AuthorizationRole authRole, AccessRights rights, Date validFrom, Date validTo, String provider) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException, ConstructionException {
        CVCPublicKey cvcPublicKey = KeyFactory.createInstance(publicKey, algorithmName, authRole);
        CVCertificateBody body = new CVCertificateBody(caRef, cvcPublicKey, holderRef, authRole, rights, validFrom, validTo);
        CVCertificate cvc = new CVCertificate(body);
        Signature signature = Signature.getInstance(AlgorithmUtil.convertAlgorithmNameToCVC(algorithmName), provider);
        signature.initSign(signerKey);
        signature.update(cvc.getTBS());
        byte[] signdata = signature.sign();
        byte[] sig = BCECUtil.convertX962SigToCVC(algorithmName, signdata);
        cvc.setSignature(sig);
        return cvc;
    }

    public static CVCertificate createCertificate(PublicKey publicKey, PrivateKey signerKey, String algorithmName, CAReferenceField caRef, HolderReferenceField holderRef, AuthorizationRoleEnum authRole, AccessRightEnum rights, Date validFrom, Date validTo, String provider) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException, ConstructionException {
        return CertificateGenerator.createCertificate(publicKey, signerKey, algorithmName, caRef, holderRef, (AuthorizationRole)authRole, (AccessRights)rights, validFrom, validTo, provider);
    }

    public static CVCertificate createRequest(KeyPair keyPair, String algorithmName, HolderReferenceField holderRef) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException, ConstructionException {
        return CertificateGenerator.createRequest(keyPair, algorithmName, holderRef, "BC");
    }

    public static CVCertificate createRequest(KeyPair keyPair, String algorithmName, HolderReferenceField holderRef, String signProvicer) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException, ConstructionException {
        return CertificateGenerator.createRequest(keyPair, algorithmName, null, holderRef, signProvicer);
    }

    public static CVCertificate createRequest(KeyPair keyPair, String algorithmName, CAReferenceField caRef, HolderReferenceField holderRef) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException, ConstructionException {
        return CertificateGenerator.createRequest(keyPair, algorithmName, caRef, holderRef, "BC");
    }

    public static CVCertificate createRequest(KeyPair keyPair, String algorithmName, CAReferenceField caRef, HolderReferenceField holderRef, String signProvicer) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException, ConstructionException {
        CVCPublicKey cvcPublicKey = KeyFactory.createInstance(keyPair.getPublic(), algorithmName, null);
        CVCertificateBody reqBody = new CVCertificateBody(caRef, cvcPublicKey, holderRef);
        CVCertificate cvc = new CVCertificate(reqBody);
        Signature innerSign = Signature.getInstance(AlgorithmUtil.convertAlgorithmNameToCVC(algorithmName), signProvicer);
        innerSign.initSign(keyPair.getPrivate());
        innerSign.update(cvc.getTBS());
        byte[] signdata = innerSign.sign();
        byte[] sig = BCECUtil.convertX962SigToCVC(algorithmName, signdata);
        cvc.setSignature(sig);
        return cvc;
    }

    public static CVCAuthenticatedRequest createAuthenticatedRequest(CVCertificate cvcRequest, KeyPair keyPair, String algorithmName, CAReferenceField caRef) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException, ConstructionException {
        return CertificateGenerator.createAuthenticatedRequest(cvcRequest, keyPair, algorithmName, caRef, "BC");
    }

    public static CVCAuthenticatedRequest createAuthenticatedRequest(CVCertificate cvcRequest, KeyPair keyPair, String algorithmName, CAReferenceField caRef, String signProvider) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException, ConstructionException {
        CVCAuthenticatedRequest authRequest = new CVCAuthenticatedRequest(cvcRequest, caRef);
        Signature outerSign = Signature.getInstance(AlgorithmUtil.convertAlgorithmNameToCVC(algorithmName), signProvider);
        outerSign.initSign(keyPair.getPrivate());
        outerSign.update(authRequest.getTBS());
        byte[] signdata = outerSign.sign();
        byte[] sig = BCECUtil.convertX962SigToCVC(algorithmName, signdata);
        authRequest.setSignature(sig);
        return authRequest;
    }
}

