/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.ejbca.cvc.AbstractDataField;
import org.ejbca.cvc.CVCTagEnum;

public class DateField
extends AbstractDataField {
    private static final long serialVersionUID = 6092901788235446614L;
    private static final int DATE_ARRAY_SIZE = 6;
    private static final TimeZone GMTTIMEZONE = TimeZone.getTimeZone("GMT");
    private static final DateFormat FORMAT_PRINTABLE = new SimpleDateFormat("yyyy-MM-dd");
    private Date date;

    DateField(CVCTagEnum type) {
        super(type);
    }

    DateField(CVCTagEnum type, Date date) {
        this(type);
        Calendar cal = Calendar.getInstance(GMTTIMEZONE);
        cal.setTimeInMillis(date.getTime());
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        cal.clear();
        cal.set(year, month, day);
        this.date = cal.getTime();
    }

    DateField(CVCTagEnum type, byte[] data) {
        this(type);
        if (data == null || data.length != 6) {
            throw new IllegalArgumentException("data argument must have length 6, was " + (data == null ? 0 : data.length));
        }
        int year = 2000 + data[0] * 10 + data[1];
        int month = data[2] * 10 + data[3] - 1;
        int day = data[4] * 10 + data[5];
        Calendar cal = Calendar.getInstance(GMTTIMEZONE);
        cal.clear();
        if (type == CVCTagEnum.EFFECTIVE_DATE) {
            cal.set(year, month, day, 0, 0, 0);
        } else {
            cal.set(year, month, day, 23, 59, 59);
        }
        this.date = cal.getTime();
    }

    public Date getDate() {
        return this.date;
    }

    protected byte[] getEncoded() {
        byte[] dateArr = new byte[6];
        Calendar cal = Calendar.getInstance(GMTTIMEZONE);
        cal.setTimeInMillis(this.date.getTime());
        int year = cal.get(1) - 2000;
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        dateArr[0] = (byte)(year / 10);
        dateArr[1] = (byte)(year % 10);
        dateArr[2] = (byte)(month / 10);
        dateArr[3] = (byte)(month % 10);
        dateArr[4] = (byte)(day / 10);
        dateArr[5] = (byte)(day % 10);
        return dateArr;
    }

    protected String valueAsText() {
        return FORMAT_PRINTABLE.format(this.date);
    }

    static {
        FORMAT_PRINTABLE.setTimeZone(GMTTIMEZONE);
    }
}

