/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.ArrayList;
import java.util.Collection;
import org.ejbca.cvc.CVCertificate;
import org.ejbca.cvc.CardVerifiableCertificate;
import org.ejbca.cvc.CertificateParser;
import org.ejbca.cvc.exception.ConstructionException;
import org.ejbca.cvc.exception.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKCVCertificateFactory
extends CertificateFactorySpi {
    private byte[] readBytes(InputStream in) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int len = 0;
        byte[] buf = new byte[512];
        while ((len = in.read(buf)) > 0) {
            os.write(buf, 0, len);
        }
        in.close();
        os.close();
        return os.toByteArray();
    }

    @Override
    public Certificate engineGenerateCertificate(InputStream in) throws CertificateException {
        CardVerifiableCertificate ret = null;
        try {
            byte[] certData = this.readBytes(in);
            CVCertificate parsedObject = CertificateParser.parseCertificate(certData);
            ret = new CardVerifiableCertificate(parsedObject);
        }
        catch (IOException e) {
            throw new CertificateException(e.toString());
        }
        catch (ParseException e) {
            throw new CertificateException(e.toString());
        }
        catch (ConstructionException e) {
            throw new CertificateException(e.toString());
        }
        return ret;
    }

    public Collection<Certificate> engineGenerateCertificates(InputStream inStream) throws CertificateException {
        Certificate cert = this.engineGenerateCertificate(inStream);
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        certs.add(cert);
        return certs;
    }

    @Override
    public CRL engineGenerateCRL(InputStream inStream) throws CRLException {
        throw new CRLException("CVC CertificateFactory can not create CRLs");
    }

    public Collection<CRL> engineGenerateCRLs(InputStream inStream) throws CRLException {
        throw new CRLException("CVC CertificateFactory can not create CRLs");
    }
}

