/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import org.ejbca.cvc.ByteField;
import org.ejbca.cvc.CVCPublicKey;
import org.ejbca.cvc.CVCTagEnum;
import org.ejbca.cvc.GenericPublicKeyField;
import org.ejbca.cvc.OIDField;
import org.ejbca.cvc.exception.ConstructionException;

public class PublicKeyRSA
extends CVCPublicKey
implements RSAPublicKey {
    private static final long serialVersionUID = 1L;
    private static CVCTagEnum[] allowedFields = new CVCTagEnum[]{CVCTagEnum.OID, CVCTagEnum.MODULUS, CVCTagEnum.EXPONENT};

    protected CVCTagEnum[] getAllowedFields() {
        return allowedFields;
    }

    PublicKeyRSA(GenericPublicKeyField genericKey) throws ConstructionException, NoSuchFieldException {
        ByteField modulusField = (ByteField)genericKey.getSubfield(CVCTagEnum.MODULUS);
        modulusField.setShowBitLength(true);
        this.addSubfield(genericKey.getSubfield(CVCTagEnum.OID));
        this.addSubfield(modulusField);
        this.addSubfield(genericKey.getSubfield(CVCTagEnum.EXPONENT));
    }

    PublicKeyRSA(OIDField oid, RSAPublicKey rsaKey) throws ConstructionException {
        this.addSubfield(oid);
        this.addSubfield(new ByteField(CVCTagEnum.MODULUS, PublicKeyRSA.trimByteArray(rsaKey.getModulus().toByteArray()), true));
        this.addSubfield(new ByteField(CVCTagEnum.EXPONENT, PublicKeyRSA.trimByteArray(rsaKey.getPublicExponent().toByteArray())));
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public String getFormat() {
        return "CVC";
    }

    public BigInteger getPublicExponent() {
        try {
            ByteField exp = (ByteField)this.getSubfield(CVCTagEnum.EXPONENT);
            return new BigInteger(1, exp.getData());
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    public BigInteger getModulus() {
        try {
            ByteField exp = (ByteField)this.getSubfield(CVCTagEnum.MODULUS);
            return new BigInteger(1, exp.getData());
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }
}

