/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import org.ejbca.cvc.AbstractDataField;
import org.ejbca.cvc.CVCTagEnum;

public abstract class ReferenceField
extends AbstractDataField {
    private static final long serialVersionUID = 1L;
    private String country = null;
    private String mnemonic = null;
    private String sequence = null;

    public ReferenceField(CVCTagEnum tag, String country, String mnemonic, String seq) {
        super(tag);
        if (country.length() != 2) {
            throw new IllegalArgumentException("Country code length must be 2, was " + country.length());
        }
        if (!this.isValidCountry(country)) {
            throw new IllegalArgumentException("Unknown country code: " + country);
        }
        if (mnemonic.length() == 0) {
            throw new IllegalArgumentException("Holder mnemonic too short, must have at least one character");
        }
        if (mnemonic.length() > 9) {
            throw new IllegalArgumentException("Holder mnemonic too long, max=9, was " + mnemonic.length());
        }
        if (seq.length() != 5) {
            throw new IllegalArgumentException("Sequence number must have length 5, was " + seq.length());
        }
        for (int i = 0; i < seq.length(); ++i) {
            char c = seq.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            throw new IllegalArgumentException("Sequence number can only contain alphanumerics: " + seq);
        }
        this.country = country;
        this.mnemonic = mnemonic;
        this.sequence = seq;
    }

    protected ReferenceField(CVCTagEnum tag, byte[] data) {
        super(tag);
        String dataStr = new String(data);
        this.country = dataStr.substring(0, 2);
        this.mnemonic = dataStr.substring(2, dataStr.length() - 5);
        this.sequence = dataStr.substring(dataStr.length() - 5);
    }

    public String getConcatenated() {
        return this.country + this.mnemonic + this.sequence;
    }

    public String getCountry() {
        return this.country;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public String getSequence() {
        return this.sequence;
    }

    protected byte[] getEncoded() {
        return this.getConcatenated().getBytes();
    }

    private boolean okChar(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private boolean isValidCountry(String countryCode) {
        return this.okChar(countryCode.charAt(0)) && this.okChar(countryCode.charAt(1));
    }

    public String valueAsText() {
        return this.country + "/" + this.mnemonic + "/" + this.sequence;
    }
}

