/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import org.ejbca.cvc.AbstractSequence;
import org.ejbca.cvc.CVCAuthenticatedRequest;
import org.ejbca.cvc.CVCAuthorizationTemplate;
import org.ejbca.cvc.CVCTagEnum;
import org.ejbca.cvc.CVCertificate;
import org.ejbca.cvc.CVCertificateBody;
import org.ejbca.cvc.GenericPublicKeyField;

public class SequenceFactory {
    public static AbstractSequence createSequence(CVCTagEnum tag) {
        if (!tag.isSequence()) {
            throw new IllegalArgumentException("Tag " + (Object)((Object)tag) + " is not a sequence");
        }
        switch (tag) {
            case CV_CERTIFICATE: {
                return new CVCertificate();
            }
            case CERTIFICATE_BODY: {
                return new CVCertificateBody();
            }
            case PUBLIC_KEY: {
                return new GenericPublicKeyField();
            }
            case HOLDER_AUTH_TEMPLATE: {
                return new CVCAuthorizationTemplate();
            }
            case REQ_AUTHENTICATION: {
                return new CVCAuthenticatedRequest();
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)tag));
    }
}

