/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import org.ejbca.cvc.AbstractDataField;
import org.ejbca.cvc.AccessRightAuthTerm;
import org.ejbca.cvc.AccessRightEnum;
import org.ejbca.cvc.AccessRightSignTermEnum;
import org.ejbca.cvc.AccessRights;
import org.ejbca.cvc.AccessRightsRawValue;
import org.ejbca.cvc.AuthorizationRole;
import org.ejbca.cvc.AuthorizationRoleAuthTermEnum;
import org.ejbca.cvc.AuthorizationRoleEnum;
import org.ejbca.cvc.AuthorizationRoleRawValue;
import org.ejbca.cvc.AuthorizationRoleSignTermEnum;
import org.ejbca.cvc.CVCObjectIdentifiers;
import org.ejbca.cvc.CVCTagEnum;
import org.ejbca.cvc.OIDField;
import org.ejbca.cvc.util.StringConverter;

public class AuthorizationField
extends AbstractDataField {
    private static final long serialVersionUID = -5478250843535697147L;
    private AuthorizationRole role;
    private AccessRights rights;

    AuthorizationField() {
        super(CVCTagEnum.ROLE_AND_ACCESS_RIGHTS);
    }

    AuthorizationField(AuthorizationRole role, AccessRights rights) {
        this();
        this.role = role;
        this.rights = rights;
    }

    AuthorizationField(AuthorizationRoleEnum role, AccessRightEnum rights) {
        this((AuthorizationRole)role, (AccessRights)rights);
    }

    AuthorizationField(byte[] data) {
        this();
        if (data.length < 1) {
            throw new IllegalArgumentException("byte array length must be at least 1");
        }
        this.role = new AuthorizationRoleRawValue(data[0]);
        this.rights = new AccessRightsRawValue(data);
    }

    @Deprecated
    public AuthorizationRoleEnum getRole() {
        if (!(this.role instanceof AuthorizationRoleEnum)) {
            throw new UnsupportedOperationException("Attempted to use deprecated getRole method with in an AT or ST certificate chain. It handles IS only.");
        }
        return (AuthorizationRoleEnum)this.role;
    }

    public AuthorizationRole getAuthRole() {
        return this.role;
    }

    @Deprecated
    public AccessRightEnum getAccessRight() {
        if (!(this.rights instanceof AccessRightEnum)) {
            throw new UnsupportedOperationException("Attempted to use deprecated getAccessRight method with an AT or ST certificate chain. It handles IS only.");
        }
        return (AccessRightEnum)this.rights;
    }

    public AccessRights getAccessRights() {
        return this.rights;
    }

    @Override
    protected byte[] getEncoded() {
        byte[] encoded = this.rights.getEncoded();
        encoded[0] = (byte)(encoded[0] | this.role.getValue());
        return encoded;
    }

    @Override
    protected String valueAsText() {
        return StringConverter.byteToHex(this.getEncoded()) + ": " + this.role + "/" + this.rights;
    }

    private static AuthorizationRole getRoleFromByte(OIDField oid, byte b) {
        Enum[] values;
        byte testVal = (byte)(b & 0xC0);
        if (CVCObjectIdentifiers.id_EAC_ePassport.equals(oid)) {
            values = AuthorizationRoleEnum.values();
        } else if (CVCObjectIdentifiers.id_EAC_roles_ST.equals(oid)) {
            values = AuthorizationRoleSignTermEnum.values();
        } else if (CVCObjectIdentifiers.id_EAC_roles_AT.equals(oid)) {
            values = AuthorizationRoleAuthTermEnum.values();
        } else {
            throw new IllegalArgumentException("incorrect or unsupported OID");
        }
        AuthorizationRoleEnum foundRole = null;
        for (AuthorizationRoleEnum authorizationRoleEnum : values) {
            if (testVal != authorizationRoleEnum.getValue()) continue;
            foundRole = authorizationRoleEnum;
            break;
        }
        return foundRole;
    }

    private static AccessRights getRightsFromBytes(OIDField oid, byte[] data) {
        if (CVCObjectIdentifiers.id_EAC_ePassport.equals(oid)) {
            if (data.length != 1) {
                throw new IllegalArgumentException("byte array length must be 1, was " + data.length);
            }
            byte testVal = (byte)(data[0] & 3);
            AccessRightEnum foundRight = null;
            for (AccessRightEnum right : AccessRightEnum.values()) {
                if (testVal != right.getValue()) continue;
                foundRight = right;
                break;
            }
            return foundRight;
        }
        if (CVCObjectIdentifiers.id_EAC_roles_ST.equals(oid)) {
            if (data.length != 1) {
                throw new IllegalArgumentException("byte array length must be 1, was " + data.length);
            }
            byte testVal = (byte)(data[0] & 3);
            AccessRightSignTermEnum foundRight = null;
            for (AccessRightSignTermEnum right : AccessRightSignTermEnum.values()) {
                if (testVal != right.getValue()) continue;
                foundRight = right;
                break;
            }
            return foundRight;
        }
        if (CVCObjectIdentifiers.id_EAC_roles_AT.equals(oid)) {
            if (data.length != 5) {
                throw new IllegalArgumentException("byte array length must be 5, was " + data.length);
            }
            return new AccessRightAuthTerm(data);
        }
        throw new IllegalArgumentException("incorrect or unsupported OID");
    }

    void fixEnumTypes(OIDField oid) {
        this.role = AuthorizationField.getRoleFromByte(oid, this.role.getValue());
        this.rights = AuthorizationField.getRightsFromBytes(oid, this.rights.getEncoded());
    }
}

