/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc.example;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

public final class FileHelper {
    private FileHelper() {
    }

    public static byte[] loadFile(String path) throws IOException {
        return FileHelper.loadFile(new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadFile(File file) throws IOException {
        byte[] dataBuffer = null;
        FileInputStream inStream = null;
        try {
            int length = (int)file.length();
            dataBuffer = new byte[length];
            inStream = new FileInputStream(file);
            int offset = 0;
            int readBytes = 0;
            boolean readMore = true;
            while (readMore) {
                readBytes = inStream.read(dataBuffer, offset, length - offset);
                readMore = readBytes > 0 && (offset += readBytes) != length;
            }
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException e1) {
                System.out.println("loadFile - error when closing: " + e1);
            }
        }
        return dataBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, byte[] data) throws IOException {
        FileOutputStream outStream = null;
        FilterOutputStream bout = null;
        try {
            outStream = new FileOutputStream(file);
            bout = new BufferedOutputStream(outStream, 1000);
            bout.write(data);
        }
        finally {
            if (bout != null) {
                bout.close();
            }
        }
    }
}

