/*
 * Decompiled with CFR 0.152.
 */
package org.ejml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.ejml.GenerateCode32;

public abstract class CodeGeneratorBase {
    public static String copyright = "/** Copyright Peter Abeles. Failed to load copyright.txt. */";
    protected PrintStream out;
    protected String className;

    public abstract void generate() throws FileNotFoundException;

    protected String standardClassDocClosing(String ... authors) {
        return " *\n * <p>DO NOT MODIFY. Automatically generated code created by " + this.getClass().getSimpleName() + "</p>\n *\n * @author " + authors[0] + "\n */\n@Generated(\"" + this.getClass().getCanonicalName() + "\")\n";
    }

    public void setOutputFile(String className) throws FileNotFoundException {
        this.className = className;
        this.out = new PrintStream(new FileOutputStream(className + ".java"));
        this.out.print(copyright);
        this.out.println();
        this.out.println("package " + this.getPackage() + ";");
        this.out.println();
        this.out.println("import javax.annotation.Generated;");
    }

    public static String readFile(String path, Charset encoding) throws IOException {
        return new String(Files.readAllBytes(Paths.get(path, new String[0])), encoding);
    }

    public String getPackage() {
        return this.getClass().getPackage().getName();
    }

    static {
        try {
            File pathCopyright = new File(GenerateCode32.findPathToProjectRoot(), "docs/copyright.txt");
            copyright = CodeGeneratorBase.readFile(pathCopyright.getAbsolutePath(), StandardCharsets.UTF_8).trim() + "\n";
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

