/*
 * Decompiled with CFR 0.152.
 */
package org.ejml;

import com.peterabeles.autocode.ConvertFile32From64;
import java.io.File;
import org.ejml.GenerateCode32;

public class GenerateJavaCode32
extends GenerateCode32 {
    public GenerateJavaCode32() {
        super("java", new ConvertFile32From64(false));
        String[] sufficeRoot = new String[]{"DRM", "DMA", "DRB", "SCC", "STL", "DF2", "DF3", "DF4", "DF5", "DF6", "TRIPLET"};
        this.suffices64.add("_DDRB_to_DDRM");
        this.suffices64.add("_F64");
        this.suffices32.add("_FDRB_to_FDRM");
        this.suffices32.add("_F32");
        for (String suffice : sufficeRoot) {
            this.suffices64.add("_D" + suffice);
            this.suffices32.add("_F" + suffice);
            this.suffices64.add("_Z" + suffice);
            this.suffices32.add("_C" + suffice);
        }
        this.suffices64.add("Features_D");
        this.suffices32.add("Features_F");
        this.prefix64.add("DGrow");
        this.prefix32.add("FGrow");
        this.prefix64.add("DOperator");
        this.prefix32.add("FOperator");
        this.prefix64.add("DMonoid");
        this.prefix32.add("FMonoid");
        this.prefix64.add("DSemiRing");
        this.prefix32.add("FSemiRing");
        this.prefix64.add("DMonoids");
        this.prefix32.add("FMonoids");
        this.prefix64.add("DSemiRings");
        this.prefix32.add("FSemiRings");
        this.prefix64.add("DMask");
        this.prefix32.add("FMask");
        this.prefix64.add("DScalar");
        this.prefix32.add("FScalar");
        this.prefix64.add("DMatrix");
        this.prefix32.add("FMatrix");
        this.prefix64.add("ZMatrix");
        this.prefix32.add("CMatrix");
        this.prefix64.add("DEigen");
        this.prefix32.add("FEigen");
        this.prefix64.add("DSubmatrix");
        this.prefix32.add("FSubmatrix");
        this.prefix64.add("DConvert");
        this.prefix32.add("FConvert");
        this.prefix64.add("GenericTestsDMatrix");
        this.prefix32.add("GenericTestsFMatrix");
        int N = this.prefix64.size();
        for (int i = 0; i < N; ++i) {
            this.prefix64.add("Test" + (String)this.prefix64.get(i));
            this.prefix32.add("Test" + (String)this.prefix32.get(i));
        }
        this.converter.markAsAutoGenerated = true;
        this.converter.replacePattern("DoubleStep", "FIXED_STEP");
        this.converter.replacePattern("double", "float");
        this.converter.replacePattern("Double", "Float");
        for (String suffice : sufficeRoot) {
            this.converter.replacePattern("_D" + suffice, "_F" + suffice);
            this.converter.replacePattern("_Z" + suffice, "_C" + suffice);
            this.converter.replacePattern("MatrixType.D" + suffice, "MatrixType.F" + suffice);
            this.converter.replacePattern("MatrixType.Z" + suffice, "MatrixType.C" + suffice);
            this.converter.replacePattern(".getD" + suffice, ".getF" + suffice);
            this.converter.replacePattern(".getZ" + suffice, ".getC" + suffice);
        }
        this.converter.replacePattern("DScalar", "FScalar");
        this.converter.replacePattern("DOperator", "FOperator");
        this.converter.replacePattern("DMonoid", "FMonoid");
        this.converter.replacePattern("DSemiRing", "FSemiRing");
        this.converter.replacePattern("DMask", "FMask");
        this.converter.replacePattern("DConvert", "FConvert");
        this.converter.replacePattern("DGrowArray", "FGrowArray");
        this.converter.replacePattern("DMatrix", "FMatrix");
        this.converter.replacePattern("DSubmatrix", "FSubmatrix");
        this.converter.replacePattern("DEigen", "FEigen");
        this.converter.replacePattern("ZComplex", "CComplex");
        this.converter.replacePattern("ZMatrix", "CMatrix");
        this.converter.replacePattern("ZSubmatrix", "CSubmatrix");
        this.converter.replacePattern("Features_D;", "Features_F;");
        this.converter.replacePattern("Features_D.", "Features_F.");
        this.converter.replacePattern("lookupDDRM", "lookupFDRM");
        this.converter.replacePattern("F64", "F32");
        this.converter.replacePattern("random64", "random32");
        this.converter.replacePattern("64-bit", "32-bit");
        this.converter.replacePattern("UtilEjml.PI", "UtilEjml.F_PI");
        this.converter.replacePattern("UtilEjml.EPS", "UtilEjml.F_EPS");
        this.converter.replaceStartsWith("Math.sqrt", "(float)Math.sqrt");
        this.converter.replaceStartsWith("Math.pow", "(float)Math.pow");
        this.converter.replaceStartsWith("Math.sin", "(float)Math.sin");
        this.converter.replaceStartsWith("Math.cos", "(float)Math.cos");
        this.converter.replaceStartsWith("Math.tan", "(float)Math.tan");
        this.converter.replaceStartsWith("Math.atan", "(float)Math.atan");
        this.converter.replaceStartsWith("Math.log", "(float)Math.log");
        this.converter.replaceStartsWith("Math.exp", "(float)Math.exp");
        this.converter.replacePatternAfter("FIXED_STEP", "DoubleStep");
    }

    public static void main(String[] args) {
        String path = GenerateJavaCode32.findPathToProjectRoot();
        System.out.println("Path to project root: " + path);
        String[] coreDir = new String[]{"main/ejml-simple/src/org/ejml/simple/ops", "main/ejml-core/src/org/ejml/data", "main/ejml-core/test/org/ejml/data", "main/ejml-core/test/org/ejml", "main/ejml-core/src/org/ejml/ops", "main/ejml-core/test/org/ejml/ops", "main/ejml-core/src/org/ejml/masks", "main/ejml-core/test/org/ejml/masks", "main/ejml-experimental/src/org/ejml/dense/row/decomposition/bidiagonal/"};
        GenerateJavaCode32 app = new GenerateJavaCode32();
        for (String dir : coreDir) {
            app.process(new File(path, dir));
        }
        for (String module : new String[]{"dense", "sparse"}) {
            GenerateJavaCode32.recursiveDelete(new File(path, "main/ejml-f" + module + "/src"), true);
            GenerateJavaCode32.recursiveDelete(new File(path, "main/ejml-c" + module + "/src"), true);
            GenerateJavaCode32.recursiveDelete(new File(path, "main/ejml-f" + module + "/test"), true);
            GenerateJavaCode32.recursiveDelete(new File(path, "main/ejml-c" + module + "/test"), true);
            app.process(new File(path, "main/ejml-d" + module + "/src"), new File(path, "main/ejml-f" + module + "/src"));
            app.process(new File(path, "main/ejml-d" + module + "/test"), new File(path, "main/ejml-f" + module + "/test"));
            if (!module.equals("dense")) continue;
            app.process(new File(path, "main/ejml-z" + module + "/src"), new File(path, "main/ejml-c" + module + "/src"));
            app.process(new File(path, "main/ejml-z" + module + "/test"), new File(path, "main/ejml-c" + module + "/test"));
        }
    }
}

