/*
 * Decompiled with CFR 0.152.
 */
package org.ejml;

import com.peterabeles.auto64fto32f.ConvertFile32From64;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.ejml.GenerateJavaCode32;
import org.ejml.GenerateKotlinCode32;

public class GenerateCode32 {
    final ConvertFile32From64 converter;
    final List<String> suffices64 = new ArrayList<String>();
    final List<String> suffices32 = new ArrayList<String>();
    final List<String> prefix64 = new ArrayList<String>();
    final List<String> prefix32 = new ArrayList<String>();
    final List<String> blacklist = new ArrayList<String>();
    final String codeSuffix;

    public GenerateCode32(String codeSuffix, ConvertFile32From64 converter) {
        this.codeSuffix = codeSuffix;
        this.converter = converter;
    }

    public void process(File inputDirectory) {
        this.process(inputDirectory, inputDirectory);
    }

    public void process(File inputDirectory, File outputDirectory) {
        String fileSuffix = "." + this.codeSuffix;
        int lengthSuffix = fileSuffix.length();
        if (!inputDirectory.isDirectory()) {
            System.err.println("Input isn't a directory. " + inputDirectory);
            return;
        }
        if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
            throw new RuntimeException("Can't create output directory");
        }
        if (!outputDirectory.isDirectory()) {
            throw new IllegalArgumentException("Output isn't a directory");
        }
        System.out.println("---- Directory " + inputDirectory);
        File[] files = inputDirectory.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            String s32;
            String s64;
            String s;
            int i;
            String n = f.getName();
            boolean blacklisted = false;
            for (int i2 = 0; i2 < this.blacklist.size(); ++i2) {
                if (!n.contains(this.blacklist.get(i2))) continue;
                blacklisted = true;
                break;
            }
            if (blacklisted) continue;
            int matchedIndex = -1;
            boolean suffix = true;
            for (i = 0; i < this.suffices64.size(); ++i) {
                s = this.suffices64.get(i);
                if (!n.endsWith(s + fileSuffix)) continue;
                matchedIndex = i;
                break;
            }
            if (matchedIndex == -1) {
                for (i = 0; i < this.prefix64.size(); ++i) {
                    s = this.prefix64.get(i);
                    if (!n.startsWith(s) || !n.endsWith(fileSuffix)) continue;
                    matchedIndex = i;
                    suffix = false;
                    break;
                }
            }
            if (matchedIndex == -1) continue;
            if (suffix) {
                s64 = this.suffices64.get(matchedIndex);
                s32 = this.suffices32.get(matchedIndex);
                n = n.substring(0, n.length() - s64.length() - lengthSuffix) + s32 + fileSuffix;
            } else {
                s64 = this.prefix64.get(matchedIndex);
                s32 = this.prefix32.get(matchedIndex);
                n = s32 + n.substring(s64.length(), n.length());
            }
            try {
                System.out.println("Generating " + n);
                this.converter.process(f, new File(outputDirectory, n));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (File f : files) {
            if (!f.isDirectory() || f.isHidden()) continue;
            this.process(f, new File(outputDirectory, f.getName()));
        }
    }

    public static void recursiveDelete(File d, boolean first) {
        File[] files;
        if (first) {
            System.out.println("Cleaning out " + d.getPath());
            if (!d.exists()) {
                return;
            }
        }
        if (!d.isDirectory()) {
            throw new RuntimeException("Expected directory at " + d);
        }
        for (File f : files = d.listFiles()) {
            if (f.isDirectory()) {
                GenerateCode32.recursiveDelete(f, false);
            }
            if (f.delete()) continue;
            throw new RuntimeException("Failed to delete " + f.getPath());
        }
    }

    public static String findPathToProjectRoot() {
        File d;
        String path = "./";
        while (!new File(d = new File(path), "main").exists() || !new File(d, ".gitignore").exists()) {
            path = "../" + path;
        }
        return Paths.get(path, new String[0]).normalize().toFile().getAbsolutePath();
    }

    public static String projectRelativePath(String path) {
        File f = new File(path);
        if (f.isAbsolute()) {
            return path;
        }
        return new File(GenerateCode32.findPathToProjectRoot(), path).getAbsolutePath();
    }

    public static String readLine(InputStream input, StringBuilder buffer) throws IOException {
        buffer.setLength(0);
        int v;
        while ((v = input.read()) != -1 && v != 10) {
            buffer.append((char)v);
        }
        return buffer.toString();
    }

    public static void main(String[] args) {
        GenerateJavaCode32.main(args);
        GenerateKotlinCode32.main(args);
    }
}

