/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.eig.watched;

import org.ejml.UtilEjml;
import org.ejml.alg.dense.decomposition.TriangularSolver;
import org.ejml.alg.dense.decomposition.eig.watched.WatchedDoubleStepQREigen;
import org.ejml.data.Complex64F;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.data.RealMatrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.LinearSolverFactory;
import org.ejml.interfaces.linsol.LinearSolver;
import org.ejml.ops.CommonOps;
import org.ejml.ops.NormOps;
import org.ejml.ops.SpecializedOps;

public class WatchedDoubleStepQREigenvector {
    WatchedDoubleStepQREigen implicit;
    DenseMatrix64F Q;
    DenseMatrix64F[] eigenvectors;
    DenseMatrix64F eigenvectorTemp;
    LinearSolver solver;
    Complex64F[] origEigenvalues;
    int N;
    int[] splits;
    int numSplits;
    int x1;
    int x2;
    int indexVal;
    boolean onscript;

    public boolean process(WatchedDoubleStepQREigen implicit, DenseMatrix64F A, DenseMatrix64F Q_h) {
        this.implicit = implicit;
        if (this.N != A.numRows) {
            this.N = A.numRows;
            this.Q = new DenseMatrix64F(this.N, this.N);
            this.splits = new int[this.N];
            this.origEigenvalues = new Complex64F[this.N];
            this.eigenvectors = new DenseMatrix64F[this.N];
            this.eigenvectorTemp = new DenseMatrix64F(this.N, 1);
            this.solver = LinearSolverFactory.linear(0);
        } else {
            this.eigenvectors = new DenseMatrix64F[this.N];
        }
        System.arraycopy(implicit.eigenvalues, 0, this.origEigenvalues, 0, this.N);
        implicit.setup(A);
        implicit.setQ(this.Q);
        this.numSplits = 0;
        this.onscript = true;
        if (!this.findQandR()) {
            return false;
        }
        return this.extractVectors(Q_h);
    }

    public boolean extractVectors(DenseMatrix64F Q_h) {
        UtilEjml.memset((double[])this.eigenvectorTemp.data, (double)0.0);
        boolean triangular = true;
        for (int i = 0; i < this.N; ++i) {
            Complex64F c = this.implicit.eigenvalues[this.N - i - 1];
            if (triangular && !c.isReal()) {
                triangular = false;
            }
            if (!c.isReal() || this.eigenvectors[this.N - i - 1] != null) continue;
            this.solveEigenvectorDuplicateEigenvalue(c.real, i, triangular);
        }
        if (Q_h != null) {
            DenseMatrix64F temp = new DenseMatrix64F(this.N, 1);
            for (int i = 0; i < this.N; ++i) {
                DenseMatrix64F v = this.eigenvectors[i];
                if (v == null) continue;
                CommonOps.mult((RowD1Matrix64F)Q_h, (RowD1Matrix64F)v, (RowD1Matrix64F)temp);
                this.eigenvectors[i] = temp;
                temp = v;
            }
        }
        return true;
    }

    private void solveEigenvectorDuplicateEigenvalue(double real, int first, boolean isTriangle) {
        double scale = Math.abs(real);
        if (scale == 0.0) {
            scale = 1.0;
        }
        this.eigenvectorTemp.reshape(this.N, 1, false);
        this.eigenvectorTemp.zero();
        if (first > 0) {
            if (isTriangle) {
                this.solveUsingTriangle(real, first, this.eigenvectorTemp);
            } else {
                this.solveWithLU(real, first, this.eigenvectorTemp);
            }
        }
        this.eigenvectorTemp.reshape(this.N, 1, false);
        for (int i = first; i < this.N; ++i) {
            Complex64F c = this.implicit.eigenvalues[this.N - i - 1];
            if (!c.isReal() || !(Math.abs(c.real - real) / scale < 100.0 * UtilEjml.EPS)) continue;
            this.eigenvectorTemp.data[i] = 1.0;
            DenseMatrix64F v = new DenseMatrix64F(this.N, 1);
            CommonOps.multTransA((RowD1Matrix64F)this.Q, (RowD1Matrix64F)this.eigenvectorTemp, (RowD1Matrix64F)v);
            this.eigenvectors[this.N - i - 1] = v;
            NormOps.normalizeF(v);
            this.eigenvectorTemp.data[i] = 0.0;
        }
    }

    private void solveUsingTriangle(double real, int index, DenseMatrix64F r) {
        int i;
        for (i = 0; i < index; ++i) {
            this.implicit.A.add(i, i, -real);
        }
        SpecializedOps.subvector((RowD1Matrix64F)this.implicit.A, 0, index, index, false, 0, (RowD1Matrix64F)r);
        CommonOps.changeSign((D1Matrix64F)r);
        TriangularSolver.solveU(this.implicit.A.data, r.data, this.implicit.A.numRows, 0, index);
        for (i = 0; i < index; ++i) {
            this.implicit.A.add(i, i, real);
        }
    }

    private void solveWithLU(double real, int index, DenseMatrix64F r) {
        DenseMatrix64F A = new DenseMatrix64F(index, index);
        CommonOps.extract((RealMatrix64F)this.implicit.A, 0, index, 0, index, (RealMatrix64F)A, 0, 0);
        for (int i = 0; i < index; ++i) {
            A.add(i, i, -real);
        }
        r.reshape(index, 1, false);
        SpecializedOps.subvector((RowD1Matrix64F)this.implicit.A, 0, index, index, false, 0, (RowD1Matrix64F)r);
        CommonOps.changeSign((D1Matrix64F)r);
        if (!this.solver.setA((Matrix)A)) {
            throw new RuntimeException("Solve failed");
        }
        this.solver.solve((Matrix)r, (Matrix)r);
    }

    public boolean findQandR() {
        CommonOps.setIdentity((RowD1Matrix64F)this.Q);
        this.x1 = 0;
        this.x2 = this.N - 1;
        this.indexVal = 0;
        while (this.indexVal < this.N) {
            if (this.findNextEigenvalue()) continue;
            return false;
        }
        return true;
    }

    private boolean findNextEigenvalue() {
        boolean foundEigen = false;
        while (!foundEigen && this.implicit.steps < this.implicit.maxIterations) {
            this.implicit.incrementSteps();
            if (this.x2 < this.x1) {
                this.moveToNextSplit();
                continue;
            }
            if (this.x2 - this.x1 == 0) {
                this.implicit.addEigenAt(this.x1);
                --this.x2;
                ++this.indexVal;
                foundEigen = true;
                continue;
            }
            if (this.x2 - this.x1 == 1 && !this.implicit.isReal2x2(this.x1, this.x2)) {
                this.implicit.addComputedEigen2x2(this.x1, this.x2);
                this.x2 -= 2;
                this.indexVal += 2;
                foundEigen = true;
                continue;
            }
            if (this.implicit.steps - this.implicit.lastExceptional > this.implicit.exceptionalThreshold) {
                this.implicit.exceptionalShift(this.x1, this.x2);
                this.implicit.lastExceptional = this.implicit.steps;
                continue;
            }
            if (this.implicit.isZero(this.x2, this.x2 - 1)) {
                this.implicit.addEigenAt(this.x2);
                foundEigen = true;
                --this.x2;
                ++this.indexVal;
                continue;
            }
            this.checkSplitPerformImplicit();
        }
        return foundEigen;
    }

    private void checkSplitPerformImplicit() {
        for (int i = this.x2; i > this.x1; --i) {
            if (!this.implicit.isZero(i, i - 1)) continue;
            this.x1 = i;
            this.splits[this.numSplits++] = i - 1;
            return;
        }
        if (this.onscript) {
            if (this.implicit.steps > this.implicit.exceptionalThreshold / 2) {
                this.onscript = false;
            } else {
                Complex64F a = this.origEigenvalues[this.indexVal];
                if (a.isReal()) {
                    this.implicit.performImplicitSingleStep(this.x1, this.x2, a.getReal());
                } else if (this.x2 < this.N - 2) {
                    this.implicit.performImplicitDoubleStep(this.x1, this.x2, a.real, a.imaginary);
                } else {
                    this.onscript = false;
                }
            }
        } else if (this.x2 - this.x1 >= 1 && this.x2 < this.N - 2) {
            this.implicit.implicitDoubleStep(this.x1, this.x2);
        } else {
            this.implicit.performImplicitSingleStep(this.x1, this.x2, this.implicit.A.get(this.x2, this.x2));
        }
    }

    private void moveToNextSplit() {
        if (this.numSplits <= 0) {
            throw new RuntimeException("bad");
        }
        this.x2 = this.splits[--this.numSplits];
        this.x1 = this.numSplits > 0 ? this.splits[this.numSplits - 1] + 1 : 0;
    }

    public DenseMatrix64F getQ() {
        return this.Q;
    }

    public WatchedDoubleStepQREigen getImplicit() {
        return this.implicit;
    }

    public DenseMatrix64F[] getEigenvectors() {
        return this.eigenvectors;
    }

    public Complex64F[] getEigenvalues() {
        return this.implicit.eigenvalues;
    }
}

