/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.bidiagonal;

import org.ejml.alg.dense.decomposition.bidiagonal.BidiagonalDecompositionRow_D64;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.data.RealMatrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.BidiagonalDecomposition;
import org.ejml.interfaces.decomposition.QRPDecomposition;
import org.ejml.ops.CommonOps;

public class BidiagonalDecompositionTall_D64
implements BidiagonalDecomposition<DenseMatrix64F> {
    QRPDecomposition<DenseMatrix64F> decompQRP = DecompositionFactory.qrp(500, 100);
    BidiagonalDecomposition<DenseMatrix64F> decompBi = new BidiagonalDecompositionRow_D64();
    DenseMatrix64F B = new DenseMatrix64F(1, 1);
    int m;
    int n;
    int min;

    public void getDiagonal(double[] diag, double[] off) {
        diag[0] = this.B.get(0);
        for (int i = 1; i < this.n; ++i) {
            diag[i] = this.B.unsafe_get(i, i);
            off[i - 1] = this.B.unsafe_get(i - 1, i);
        }
    }

    public DenseMatrix64F getB(DenseMatrix64F B, boolean compact) {
        B = BidiagonalDecompositionRow_D64.handleB(B, compact, this.m, this.n, this.min);
        B.set(0, 0, this.B.get(0, 0));
        for (int i = 1; i < this.min; ++i) {
            B.set(i, i, this.B.get(i, i));
            B.set(i - 1, i, this.B.get(i - 1, i));
        }
        if (this.n > this.m) {
            B.set(this.min - 1, this.min, this.B.get(this.min - 1, this.min));
        }
        return B;
    }

    public DenseMatrix64F getU(DenseMatrix64F U, boolean transpose, boolean compact) {
        U = BidiagonalDecompositionRow_D64.handleU(U, false, compact, this.m, this.n, this.min);
        if (compact) {
            DenseMatrix64F Q1 = (DenseMatrix64F)this.decompQRP.getQ(null, true);
            DenseMatrix64F U1 = (DenseMatrix64F)this.decompBi.getU(null, false, true);
            CommonOps.mult((RowD1Matrix64F)Q1, (RowD1Matrix64F)U1, (RowD1Matrix64F)U);
        } else {
            DenseMatrix64F Q = (DenseMatrix64F)this.decompQRP.getQ((Matrix)U, false);
            DenseMatrix64F U1 = (DenseMatrix64F)this.decompBi.getU(null, false, true);
            DenseMatrix64F Q1 = CommonOps.extract(Q, 0, Q.numRows, 0, this.min);
            DenseMatrix64F tmp = new DenseMatrix64F(Q1.numRows, U1.numCols);
            CommonOps.mult((RowD1Matrix64F)Q1, (RowD1Matrix64F)U1, (RowD1Matrix64F)tmp);
            CommonOps.insert((RealMatrix64F)tmp, (RealMatrix64F)Q, 0, 0);
        }
        if (transpose) {
            CommonOps.transpose(U);
        }
        return U;
    }

    public DenseMatrix64F getV(DenseMatrix64F V, boolean transpose, boolean compact) {
        return (DenseMatrix64F)this.decompBi.getV((Matrix)V, transpose, compact);
    }

    public boolean decompose(DenseMatrix64F orig) {
        if (!this.decompQRP.decompose((Matrix)orig)) {
            return false;
        }
        this.m = orig.numRows;
        this.n = orig.numCols;
        this.min = Math.min(this.m, this.n);
        this.B.reshape(this.min, this.n, false);
        this.decompQRP.getR((Matrix)this.B, true);
        DenseMatrix64F result = new DenseMatrix64F(this.min, this.n);
        DenseMatrix64F P = this.decompQRP.getPivotMatrix(null);
        CommonOps.multTransB((RowD1Matrix64F)this.B, (RowD1Matrix64F)P, (RowD1Matrix64F)result);
        this.B.set((D1Matrix64F)result);
        return this.decompBi.decompose((Matrix)this.B);
    }

    public boolean inputModified() {
        return this.decompQRP.inputModified();
    }
}

