/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.qr;

import org.ejml.alg.dense.decomposition.TriangularSolver;
import org.ejml.alg.dense.linsol.LinearSolverAbstract_D64;
import org.ejml.alg.dense.linsol.LinearSolverSafe;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.data.RealMatrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.LinearSolverFactory;
import org.ejml.interfaces.decomposition.QRPDecomposition;
import org.ejml.interfaces.linsol.LinearSolver;
import org.ejml.ops.CommonOps;
import org.ejml.ops.SpecializedOps;

public abstract class BaseLinearSolverQrp_D64
extends LinearSolverAbstract_D64 {
    QRPDecomposition<DenseMatrix64F> decomposition;
    protected boolean norm2Solution;
    protected DenseMatrix64F Y = new DenseMatrix64F(1, 1);
    protected DenseMatrix64F R = new DenseMatrix64F(1, 1);
    protected DenseMatrix64F R11 = new DenseMatrix64F(1, 1);
    protected DenseMatrix64F I = new DenseMatrix64F(1, 1);
    protected int rank;
    protected LinearSolver<DenseMatrix64F> internalSolver = LinearSolverFactory.leastSquares(1, 1);
    private DenseMatrix64F W = new DenseMatrix64F(1, 1);

    protected BaseLinearSolverQrp_D64(QRPDecomposition<DenseMatrix64F> decomposition, boolean norm2Solution) {
        this.decomposition = decomposition;
        this.norm2Solution = norm2Solution;
        if (this.internalSolver.modifiesA()) {
            this.internalSolver = new LinearSolverSafe(this.internalSolver);
        }
    }

    public boolean setA(DenseMatrix64F A) {
        this._setA(A);
        if (!this.decomposition.decompose((Matrix)A)) {
            return false;
        }
        this.rank = this.decomposition.getRank();
        this.R.reshape(this.numRows, this.numCols);
        this.decomposition.getR((Matrix)this.R, false);
        this.R11.reshape(this.rank, this.rank);
        CommonOps.extract((RealMatrix64F)this.R, 0, this.rank, 0, this.rank, (RealMatrix64F)this.R11, 0, 0);
        if (this.norm2Solution && this.rank < this.numCols) {
            this.W.reshape(this.rank, this.numCols - this.rank);
            CommonOps.extract((RealMatrix64F)this.R, 0, this.rank, this.rank, this.numCols, (RealMatrix64F)this.W, 0, 0);
            TriangularSolver.solveU(this.R11.data, 0, this.R11.numCols, this.R11.numCols, this.W.data, 0, this.W.numCols, this.W.numCols);
            this.W.reshape(this.numCols, this.W.numCols, true);
            for (int i = 0; i < this.numCols - this.rank; ++i) {
                for (int j = 0; j < this.numCols - this.rank; ++j) {
                    if (i == j) {
                        this.W.set(i + this.rank, j, -1.0);
                        continue;
                    }
                    this.W.set(i + this.rank, j, 0.0);
                }
            }
        }
        return true;
    }

    public double quality() {
        return SpecializedOps.qualityTriangular((D1Matrix64F)this.R);
    }

    protected void upgradeSolution(DenseMatrix64F X) {
        DenseMatrix64F z = this.Y;
        if (!this.internalSolver.setA((Matrix)this.W)) {
            throw new RuntimeException("This should never happen.  Is input NaN?");
        }
        z.reshape(this.numCols - this.rank, 1);
        this.internalSolver.solve((Matrix)X, (Matrix)z);
        CommonOps.multAdd(-1.0, (RowD1Matrix64F)this.W, (RowD1Matrix64F)z, (RowD1Matrix64F)X);
    }

    @Override
    public void invert(DenseMatrix64F A_inv) {
        if (A_inv.numCols != this.numRows || A_inv.numRows != this.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for A_inv");
        }
        this.I.reshape(this.numRows, this.numRows);
        CommonOps.setIdentity((RowD1Matrix64F)this.I);
        this.solve((Matrix)this.I, (Matrix)A_inv);
    }

    public QRPDecomposition<DenseMatrix64F> getDecomposition() {
        return this.decomposition;
    }
}

