/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.chol;

import java.util.Arrays;
import org.ejml.alg.dense.decompose.CTriangularSolver;
import org.ejml.alg.dense.decompose.chol.CholeskyDecompositionCommon_CD64;
import org.ejml.alg.dense.linsol.LinearSolverAbstract_CD64;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.interfaces.decomposition.CholeskyDecomposition;
import org.ejml.ops.CSpecializedOps;

public class LinearSolverChol_CD64
extends LinearSolverAbstract_CD64 {
    CholeskyDecompositionCommon_CD64 decomposer;
    int n;
    double[] vv = new double[0];
    double[] t;

    public LinearSolverChol_CD64(CholeskyDecompositionCommon_CD64 decomposer) {
        this.decomposer = decomposer;
    }

    public boolean setA(CDenseMatrix64F A) {
        if (A.numRows != A.numCols) {
            throw new IllegalArgumentException("Matrix must be square");
        }
        this._setA(A);
        if (this.decomposer.decompose(A)) {
            this.n = A.numCols;
            if (this.vv.length < this.n * 2) {
                this.vv = new double[this.n * 2];
            }
            this.t = this.decomposer._getT().data;
            return true;
        }
        return false;
    }

    public double quality() {
        return CSpecializedOps.qualityTriangular(this.decomposer._getT());
    }

    public void solve(CDenseMatrix64F B, CDenseMatrix64F X) {
        if (B.numCols != X.numCols || B.numRows != this.n || X.numRows != this.n) {
            throw new IllegalArgumentException("Unexpected matrix size");
        }
        int numCols = B.numCols;
        double[] dataB = B.data;
        double[] dataX = X.data;
        if (this.decomposer.isLower()) {
            for (int j = 0; j < numCols; ++j) {
                int i;
                for (i = 0; i < this.n; ++i) {
                    this.vv[i * 2] = dataB[(i * numCols + j) * 2];
                    this.vv[i * 2 + 1] = dataB[(i * numCols + j) * 2 + 1];
                }
                this.solveInternalL();
                for (i = 0; i < this.n; ++i) {
                    dataX[(i * numCols + j) * 2] = this.vv[i * 2];
                    dataX[(i * numCols + j) * 2 + 1] = this.vv[i * 2 + 1];
                }
            }
        } else {
            throw new RuntimeException("Implement");
        }
    }

    private void solveInternalL() {
        CTriangularSolver.solveL_diagReal(this.t, this.vv, this.n);
        CTriangularSolver.solveConjTranL_diagReal(this.t, this.vv, this.n);
    }

    @Override
    public void invert(CDenseMatrix64F inv) {
        if (inv.numRows != this.n || inv.numCols != this.n) {
            throw new RuntimeException("Unexpected matrix dimension");
        }
        if (inv.data == this.t) {
            throw new IllegalArgumentException("Passing in the same matrix that was decomposed.");
        }
        if (!this.decomposer.isLower()) {
            throw new RuntimeException("Implement");
        }
        this.setToInverseL(inv.data);
    }

    public void setToInverseL(double[] a) {
        for (int col = 0; col < this.n; ++col) {
            Arrays.fill(this.vv, 0.0);
            this.vv[col * 2] = 1.0;
            CTriangularSolver.solveL_diagReal(this.t, this.vv, this.n);
            CTriangularSolver.solveConjTranL_diagReal(this.t, this.vv, this.n);
            for (int i = 0; i < this.n; ++i) {
                a[(i * this.numCols + col) * 2] = this.vv[i * 2];
                a[(i * this.numCols + col) * 2 + 1] = this.vv[i * 2 + 1];
            }
        }
    }

    public boolean modifiesA() {
        return this.decomposer.inputModified();
    }

    public boolean modifiesB() {
        return false;
    }

    public CholeskyDecomposition<CDenseMatrix64F> getDecomposition() {
        return this.decomposer;
    }
}

