/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import org.ejml.alg.dense.mult.CVectorVectorMult;
import org.ejml.data.CD1Matrix64F;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.data.Complex64F;
import org.ejml.ops.CCommonOps;
import org.ejml.ops.CNormOps;

public class CSpecializedOps {
    public static CDenseMatrix64F pivotMatrix(CDenseMatrix64F ret, int[] pivots, int numPivots, boolean transposed) {
        if (ret == null) {
            ret = new CDenseMatrix64F(numPivots, numPivots);
        } else {
            if (ret.numCols != numPivots || ret.numRows != numPivots) {
                throw new IllegalArgumentException("Unexpected matrix dimension");
            }
            CCommonOps.fill((CD1Matrix64F)ret, 0.0, 0.0);
        }
        if (transposed) {
            for (int i = 0; i < numPivots; ++i) {
                ret.set(pivots[i], i, 1.0, 0.0);
            }
        } else {
            for (int i = 0; i < numPivots; ++i) {
                ret.set(i, pivots[i], 1.0, 0.0);
            }
        }
        return ret;
    }

    public static double elementDiagMaxMagnitude2(CDenseMatrix64F a) {
        int size = Math.min(a.numRows, a.numCols);
        int rowStride = a.getRowStride();
        double max = 0.0;
        for (int i = 0; i < size; ++i) {
            int index = i * rowStride + i * 2;
            double real = a.data[index];
            double imaginary = a.data[index + 1];
            double m = real * real + imaginary * imaginary;
            if (!(m > max)) continue;
            max = m;
        }
        return max;
    }

    public static double qualityTriangular(CDenseMatrix64F T) {
        int N = Math.min(T.numRows, T.numCols);
        double max = CSpecializedOps.elementDiagMaxMagnitude2(T);
        if (max == 0.0) {
            return 0.0;
        }
        max = Math.sqrt(max);
        int rowStride = T.getRowStride();
        double qualityR = 1.0;
        double qualityI = 0.0;
        for (int i = 0; i < N; ++i) {
            int index = i * rowStride + i * 2;
            double real = T.data[index] / max;
            double imaginary = T.data[index] / max;
            double r = qualityR * real - qualityI * imaginary;
            double img = qualityR * imaginary + real * qualityI;
            qualityR = r;
            qualityI = img;
        }
        return Math.sqrt(qualityR * qualityR + qualityI * qualityI);
    }

    public static CDenseMatrix64F householder(CDenseMatrix64F u, double gamma) {
        int N = u.getDataLength() / 2;
        CDenseMatrix64F uut = new CDenseMatrix64F(N, N);
        CVectorVectorMult.outerProdH(u, u, uut);
        CCommonOps.elementMultiply((CD1Matrix64F)uut, -gamma, 0.0, (CD1Matrix64F)uut);
        for (int i = 0; i < N; ++i) {
            int index = (i * uut.numCols + i) * 2;
            uut.data[index] = 1.0 + uut.data[index];
        }
        return uut;
    }

    public static CDenseMatrix64F householderVector(CDenseMatrix64F x) {
        double imagTau;
        double realTau;
        CDenseMatrix64F u = x.copy();
        double max = CCommonOps.elementMaxAbs(u);
        CCommonOps.elementDivide((CD1Matrix64F)u, max, 0.0, (CD1Matrix64F)u);
        double nx = CNormOps.normF(u);
        Complex64F c = new Complex64F();
        u.get(0, 0, c);
        if (c.getMagnitude() == 0.0) {
            realTau = nx;
            imagTau = 0.0;
        } else {
            realTau = c.real / c.getMagnitude() * nx;
            imagTau = c.imaginary / c.getMagnitude() * nx;
        }
        u.set(0, 0, c.real + realTau, c.imaginary + imagTau);
        CCommonOps.elementDivide((CD1Matrix64F)u, u.getReal(0, 0), u.getImaginary(0, 0), (CD1Matrix64F)u);
        return u;
    }
}

