/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decompose.qr;

import org.ejml.alg.dense.decompose.UtilDecompositons_CD64;
import org.ejml.alg.dense.decompose.qr.QrHelperFunctions_CD64;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.data.Complex64F;
import org.ejml.interfaces.decomposition.QRDecomposition;

public class QRDecompositionHouseholder_CD64
implements QRDecomposition<CDenseMatrix64F> {
    protected CDenseMatrix64F QR;
    protected double[] u;
    protected double[] v;
    protected int numCols;
    protected int numRows;
    protected int minLength;
    protected double[] dataQR;
    protected double[] gammas;
    protected Complex64F tau = new Complex64F();
    protected boolean error;

    public void setExpectedMaxSize(int numRows, int numCols) {
        this.error = false;
        this.numCols = numCols;
        this.numRows = numRows;
        this.minLength = Math.min(numRows, numCols);
        int maxLength = Math.max(numRows, numCols);
        if (this.QR == null) {
            this.QR = new CDenseMatrix64F(numRows, numCols);
            this.u = new double[maxLength * 2];
            this.v = new double[maxLength * 2];
            this.gammas = new double[this.minLength];
        } else {
            this.QR.reshape(numRows, numCols);
        }
        this.dataQR = this.QR.data;
        if (this.u.length < maxLength * 2) {
            this.u = new double[maxLength * 2];
            this.v = new double[maxLength * 2];
        }
        if (this.gammas.length < this.minLength) {
            this.gammas = new double[this.minLength];
        }
    }

    public CDenseMatrix64F getQR() {
        return this.QR;
    }

    public CDenseMatrix64F getQ(CDenseMatrix64F Q, boolean compact) {
        Q = compact ? UtilDecompositons_CD64.checkIdentity(Q, this.numRows, this.minLength) : UtilDecompositons_CD64.checkIdentity(Q, this.numRows, this.numRows);
        for (int j = this.minLength - 1; j >= 0; --j) {
            QrHelperFunctions_CD64.extractHouseholderColumn(this.QR, j, this.numRows, j, this.u, 0);
            QrHelperFunctions_CD64.rank1UpdateMultR(Q, this.u, 0, this.gammas[j], j, j, this.numRows, this.v);
        }
        return Q;
    }

    public CDenseMatrix64F getR(CDenseMatrix64F R, boolean compact) {
        R = compact ? UtilDecompositons_CD64.checkZerosLT(R, this.minLength, this.numCols) : UtilDecompositons_CD64.checkZerosLT(R, this.numRows, this.numCols);
        for (int i = 0; i < this.minLength; ++i) {
            for (int j = i; j < this.numCols; ++j) {
                int indexQR = this.QR.getIndex(i, j);
                double realQR = this.QR.data[indexQR];
                double imagQR = this.QR.data[indexQR + 1];
                R.set(i, j, realQR, imagQR);
            }
        }
        return R;
    }

    public boolean decompose(CDenseMatrix64F A) {
        this.commonSetup(A);
        for (int j = 0; j < this.minLength; ++j) {
            this.householder(j);
        }
        return !this.error;
    }

    public boolean inputModified() {
        return false;
    }

    protected void householder(int j) {
        double max = QrHelperFunctions_CD64.extractColumnAndMax(this.QR, j, this.numRows, j, this.u, 0);
        if (max <= 0.0) {
            this.gammas[j] = 0.0;
            this.error = true;
        } else {
            double gamma;
            this.gammas[j] = gamma = QrHelperFunctions_CD64.computeTauGammaAndDivide(j, this.numRows, this.u, max, this.tau);
            double real_u_0 = this.u[j * 2] + this.tau.real;
            double imag_u_0 = this.u[j * 2 + 1] + this.tau.imaginary;
            QrHelperFunctions_CD64.divideElements(j + 1, this.numRows, this.u, 0, real_u_0, imag_u_0);
            for (int i = j + 1; i < this.numRows; ++i) {
                this.dataQR[(i * this.numCols + j) * 2] = this.u[i * 2];
                this.dataQR[(i * this.numCols + j) * 2 + 1] = this.u[i * 2 + 1];
            }
            this.u[j * 2] = 1.0;
            this.u[j * 2 + 1] = 0.0;
            QrHelperFunctions_CD64.rank1UpdateMultR(this.QR, this.u, 0, gamma, j + 1, j, this.numRows, this.v);
            if (j < this.numCols) {
                this.dataQR[(j * this.numCols + j) * 2] = -this.tau.real * max;
                this.dataQR[(j * this.numCols + j) * 2 + 1] = -this.tau.imaginary * max;
            }
        }
    }

    protected void commonSetup(CDenseMatrix64F A) {
        this.setExpectedMaxSize(A.numRows, A.numCols);
        this.QR.set(A);
    }

    public double[] getGammas() {
        return this.gammas;
    }
}

