/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import java.util.Random;
import org.ejml.data.CD1Matrix64F;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.ops.CCommonOps;

public class CRandomMatrices {
    public static CDenseMatrix64F createRandom(int numRow, int numCol, Random rand) {
        return CRandomMatrices.createRandom(numRow, numCol, -1.0, 1.0, rand);
    }

    public static CDenseMatrix64F createRandom(int numRow, int numCol, double min, double max, Random rand) {
        CDenseMatrix64F mat = new CDenseMatrix64F(numRow, numCol);
        CRandomMatrices.setRandom((CD1Matrix64F)mat, min, max, rand);
        return mat;
    }

    public static void setRandom(CDenseMatrix64F mat, Random rand) {
        CRandomMatrices.setRandom((CD1Matrix64F)mat, 0.0, 1.0, rand);
    }

    public static void setRandom(CD1Matrix64F mat, double min, double max, Random rand) {
        double[] d = mat.getData();
        int size = mat.getDataLength();
        double r = max - min;
        for (int i = 0; i < size; ++i) {
            d[i] = r * rand.nextDouble() + min;
        }
    }

    public static CDenseMatrix64F createHermPosDef(int width, Random rand) {
        CDenseMatrix64F a = CRandomMatrices.createRandom(width, 1, rand);
        CDenseMatrix64F b = new CDenseMatrix64F(1, width);
        CDenseMatrix64F c = new CDenseMatrix64F(width, width);
        CCommonOps.transposeConjugate(a, b);
        CCommonOps.mult(a, b, c);
        for (int i = 0; i < width; ++i) {
            int n = 2 * (i * width + i);
            c.data[n] = c.data[n] + 1.0;
        }
        return c;
    }

    public static CDenseMatrix64F createHermitian(int length, double min, double max, Random rand) {
        CDenseMatrix64F A = new CDenseMatrix64F(length, length);
        CRandomMatrices.setHermitian(A, min, max, rand);
        return A;
    }

    public static void setHermitian(CDenseMatrix64F A, double min, double max, Random rand) {
        if (A.numRows != A.numCols) {
            throw new IllegalArgumentException("A must be a square matrix");
        }
        double range = max - min;
        int length = A.numRows;
        for (int i = 0; i < length; ++i) {
            A.set(i, i, rand.nextDouble() * range + min, 0.0);
            for (int j = i + 1; j < length; ++j) {
                double real = rand.nextDouble() * range + min;
                double imaginary = rand.nextDouble() * range + min;
                A.set(i, j, real, imaginary);
                A.set(j, i, real, -imaginary);
            }
        }
    }
}

