/*
 * Copyright (c) 2022, Peter Abeles. All Rights Reserved.
 *
 * This file is part of Efficient Java Matrix Library (EJML).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ejml.interfaces.decomposition;

import org.ejml.data.Complex_F64;
import org.ejml.data.Matrix;


/**
 * <p>
 * Implementation of {@link EigenDecomposition} for 32-bit floats
 * </p>
 * @author Peter Abeles
 */
public interface EigenDecomposition_F64<MatrixType extends Matrix>
        extends EigenDecomposition<MatrixType> {

    /**
     * <p>
     * Returns an eigenvalue as a complex number. For symmetric matrices the returned eigenvalue will always be a real
     * number, which means the imaginary component will be equal to zero.
     * </p>
     *
     * <p>
     * NOTE: The order of the eigenvalues is dependent upon the decomposition algorithm used. This means that they may
     * or may not be ordered by magnitude. For example the QR algorithm will returns results that are partially
     * ordered by magnitude, but this behavior should not be relied upon.
     * </p>
     * 
     * @param index Index of the eigenvalue eigenvector pair.
     * @return An eigenvalue.
     */
    Complex_F64 getEigenvalue(int index);
}
