/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.sparse.csc;

import java.util.Arrays;
import org.ejml.data.DGrowArray;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.IGrowArray;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.interfaces.decomposition.LUSparseDecomposition_F64;
import org.ejml.interfaces.linsol.LinearSolverSparse;
import org.ejml.sparse.FillReducing;
import org.ejml.sparse.csc.factory.DecompositionFactory_DSCC;
import org.ejml.sparse.csc.factory.LinearSolverFactory_DSCC;
import org.ejml.sparse.csc.misc.ImplCommonOps_DSCC;
import org.ejml.sparse.csc.misc.TriangularSolver_DSCC;
import org.ejml.sparse.csc.mult.ImplSparseSparseMult_DSCC;

public class CommonOps_DSCC {
    public static boolean checkIndicesSorted(DMatrixSparseCSC A) {
        for (int j = 0; j < A.numCols; ++j) {
            int idx0 = A.col_idx[j];
            int idx1 = A.col_idx[j + 1];
            if (idx0 != idx1 && A.nz_rows[idx0] >= A.numRows) {
                return false;
            }
            for (int i = idx0 + 1; i < idx1; ++i) {
                int row = A.nz_rows[i];
                if (A.nz_rows[i - 1] >= row) {
                    return false;
                }
                if (row < A.numRows) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean checkStructure(DMatrixSparseCSC A) {
        if (A.col_idx.length < A.numCols + 1) {
            return false;
        }
        if (A.col_idx[A.numCols] != A.nz_length) {
            return false;
        }
        if (A.nz_rows.length < A.nz_length) {
            return false;
        }
        if (A.nz_values.length < A.nz_length) {
            return false;
        }
        if (A.col_idx[0] != 0) {
            return false;
        }
        for (int i = 0; i < A.numCols; ++i) {
            if (A.col_idx[i] > A.col_idx[i + 1]) {
                return false;
            }
            if (A.col_idx[i + 1] - A.col_idx[i] <= A.numRows) continue;
            return false;
        }
        if (!CommonOps_DSCC.checkSortedFlag(A)) {
            return false;
        }
        return !CommonOps_DSCC.checkDuplicateElements(A);
    }

    public static boolean checkSortedFlag(DMatrixSparseCSC A) {
        if (A.indicesSorted) {
            return CommonOps_DSCC.checkIndicesSorted(A);
        }
        return true;
    }

    public static boolean checkDuplicateElements(DMatrixSparseCSC A) {
        A = A.copy();
        A.sortIndices(null);
        return !CommonOps_DSCC.checkSortedFlag(A);
    }

    public static void transpose(DMatrixSparseCSC a, DMatrixSparseCSC a_t, IGrowArray gw) {
        if (a_t.numRows != a.numCols || a_t.numCols != a.numRows) {
            throw new IllegalArgumentException("Unexpected shape for transpose matrix");
        }
        a_t.growMaxLength(a.nz_length, false);
        a_t.nz_length = a.nz_length;
        ImplCommonOps_DSCC.transpose(a, a_t, gw);
    }

    public static void mult(DMatrixSparseCSC A, DMatrixSparseCSC B, DMatrixSparseCSC C) {
        CommonOps_DSCC.mult(A, B, C, null, null);
    }

    public static void mult(DMatrixSparseCSC A, DMatrixSparseCSC B, DMatrixSparseCSC C, IGrowArray gw, DGrowArray gx) {
        if (A.numRows != C.numRows || B.numCols != C.numCols) {
            throw new IllegalArgumentException("Inconsistent matrix shapes");
        }
        ImplSparseSparseMult_DSCC.mult(A, B, C, gw, gx);
    }

    public static void multTransA(DMatrixSparseCSC A, DMatrixSparseCSC B, DMatrixSparseCSC C, IGrowArray gw, DGrowArray gx) {
        if (A.numCols != C.numRows || B.numCols != C.numCols) {
            throw new IllegalArgumentException("Inconsistent matrix shapes");
        }
        ImplSparseSparseMult_DSCC.multTransA(A, B, C, gw, gx);
    }

    public static void multTransB(DMatrixSparseCSC A, DMatrixSparseCSC B, DMatrixSparseCSC C, IGrowArray gw, DGrowArray gx) {
        if (A.numRows != C.numRows || B.numRows != C.numCols) {
            throw new IllegalArgumentException("Inconsistent matrix shapes");
        }
        if (!B.isIndicesSorted()) {
            B.sortIndices(null);
        }
        ImplSparseSparseMult_DSCC.multTransB(A, B, C, gw, gx);
    }

    public static void mult(DMatrixSparseCSC A, DMatrixRMaj B, DMatrixRMaj C) {
        if (A.numRows != C.numRows || B.numCols != C.numCols) {
            throw new IllegalArgumentException("Inconsistent matrix shapes");
        }
        ImplSparseSparseMult_DSCC.mult(A, B, C);
    }

    public static void add(double alpha, DMatrixSparseCSC A, double beta, DMatrixSparseCSC B, DMatrixSparseCSC C, IGrowArray gw, DGrowArray gx) {
        if (A.numRows != B.numRows || A.numCols != B.numCols || A.numRows != C.numRows || A.numCols != C.numCols) {
            throw new IllegalArgumentException("Inconsistent matrix shapes");
        }
        ImplCommonOps_DSCC.add(alpha, A, beta, B, C, gw, gx);
    }

    public static DMatrixSparseCSC identity(int length) {
        return CommonOps_DSCC.identity(length, length);
    }

    public static DMatrixSparseCSC identity(int numRows, int numCols) {
        int min = Math.min(numRows, numCols);
        DMatrixSparseCSC A = new DMatrixSparseCSC(numRows, numCols, min);
        CommonOps_DSCC.setToIdentity(A);
        return A;
    }

    public static void setToIdentity(DMatrixSparseCSC A) {
        int i;
        int min = Math.min(A.numRows, A.numCols);
        A.growMaxLength(min, false);
        A.nz_length = min;
        Arrays.fill(A.nz_values, 0, min, 1.0);
        for (i = 1; i <= min; ++i) {
            A.col_idx[i] = i;
            A.nz_rows[i - 1] = i - 1;
        }
        for (i = min + 1; i <= A.numCols; ++i) {
            A.col_idx[i] = min;
        }
    }

    public static void scale(double scalar, DMatrixSparseCSC A, DMatrixSparseCSC B) {
        if (A != B) {
            if (A.numRows != B.numRows || A.numCols != B.numCols) {
                throw new IllegalArgumentException("A and B must have the same shape");
            }
            B.copyStructure(A);
            for (int i = 0; i < A.nz_length; ++i) {
                B.nz_values[i] = A.nz_values[i] * scalar;
            }
        } else {
            int i = 0;
            while (i < A.nz_length) {
                int n = i++;
                B.nz_values[n] = B.nz_values[n] * scalar;
            }
        }
    }

    public static void divide(DMatrixSparseCSC A, double scalar, DMatrixSparseCSC B) {
        if (A.numRows != B.numRows || A.numCols != B.numCols) {
            throw new IllegalArgumentException("Unexpected shape for transpose matrix");
        }
        if (A != B) {
            B.copyStructure(A);
            for (int i = 0; i < A.nz_length; ++i) {
                B.nz_values[i] = A.nz_values[i] / scalar;
            }
        } else {
            int i = 0;
            while (i < A.nz_length) {
                int n = i++;
                A.nz_values[n] = A.nz_values[n] / scalar;
            }
        }
    }

    public static void changeSign(DMatrixSparseCSC A, DMatrixSparseCSC B) {
        if (A.numRows != B.numRows || A.numCols != B.numCols) {
            throw new IllegalArgumentException("Unexpected shape for transpose matrix");
        }
        if (A != B) {
            B.copyStructure(A);
        }
        for (int i = 0; i < A.nz_length; ++i) {
            B.nz_values[i] = -A.nz_values[i];
        }
    }

    public static double elementMinAbs(DMatrixSparseCSC A) {
        if (A.nz_length == 0) {
            return 0.0;
        }
        double min = A.isFull() ? Math.abs(A.nz_values[0]) : 0.0;
        for (int i = 0; i < A.nz_length; ++i) {
            double val = Math.abs(A.nz_values[i]);
            if (!(val < min)) continue;
            min = val;
        }
        return min;
    }

    public static double elementMaxAbs(DMatrixSparseCSC A) {
        if (A.nz_length == 0) {
            return 0.0;
        }
        double max = A.isFull() ? Math.abs(A.nz_values[0]) : 0.0;
        for (int i = 0; i < A.nz_length; ++i) {
            double val = Math.abs(A.nz_values[i]);
            if (!(val > max)) continue;
            max = val;
        }
        return max;
    }

    public static double elementMin(DMatrixSparseCSC A) {
        if (A.nz_length == 0) {
            return 0.0;
        }
        double min = A.isFull() ? A.nz_values[0] : 0.0;
        for (int i = 0; i < A.nz_length; ++i) {
            double val = A.nz_values[i];
            if (!(val < min)) continue;
            min = val;
        }
        return min;
    }

    public static double elementMax(DMatrixSparseCSC A) {
        if (A.nz_length == 0) {
            return 0.0;
        }
        double max = A.isFull() ? A.nz_values[0] : 0.0;
        for (int i = 0; i < A.nz_length; ++i) {
            double val = A.nz_values[i];
            if (!(val > max)) continue;
            max = val;
        }
        return max;
    }

    public static double elementSum(DMatrixSparseCSC A) {
        if (A.nz_length == 0) {
            return 0.0;
        }
        double sum = 0.0;
        for (int i = 0; i < A.nz_length; ++i) {
            sum += A.nz_values[i];
        }
        return sum;
    }

    public static void elementMult(DMatrixSparseCSC A, DMatrixSparseCSC B, DMatrixSparseCSC C, IGrowArray gw, DGrowArray gx) {
        if (A.numCols != B.numCols || A.numRows != B.numRows || A.numCols != C.numCols || A.numRows != C.numRows) {
            throw new IllegalArgumentException("All inputs must have the same number of rows and columns");
        }
        ImplCommonOps_DSCC.elementMult(A, B, C, gw, gx);
    }

    public static DMatrixSparseCSC diag(double ... values) {
        int N = values.length;
        DMatrixSparseCSC A = new DMatrixSparseCSC(N, N, N);
        A.nz_length = N;
        for (int i = 0; i < N; ++i) {
            A.col_idx[i + 1] = i + 1;
            A.nz_rows[i] = i;
            A.nz_values[i] = values[i];
        }
        return A;
    }

    public static DMatrixSparseCSC permutationMatrix(int[] p, boolean inverse, int N, DMatrixSparseCSC P) {
        if (P == null) {
            P = new DMatrixSparseCSC(N, N, N);
        } else {
            P.reshape(N, N, N);
        }
        P.indicesSorted = true;
        P.nz_length = N;
        if (!inverse) {
            for (int i = 0; i < N; ++i) {
                P.col_idx[i + 1] = i + 1;
                P.nz_rows[p[i]] = i;
                P.nz_values[i] = 1.0;
            }
        } else {
            for (int i = 0; i < N; ++i) {
                P.col_idx[i + 1] = i + 1;
                P.nz_rows[i] = p[i];
                P.nz_values[i] = 1.0;
            }
        }
        return P;
    }

    public static void permutationVector(DMatrixSparseCSC P, int[] vector) {
        if (P.numCols != P.numRows) {
            throw new IllegalArgumentException("Expected a square matrix");
        }
        if (P.nz_length != P.numCols) {
            throw new IllegalArgumentException("Expected N non-zero elements in permutation matrix");
        }
        if (vector.length < P.numCols) {
            throw new IllegalArgumentException("vector is too short");
        }
        int M = P.numCols;
        for (int i = 0; i < M; ++i) {
            if (P.col_idx[i + 1] != i + 1) {
                throw new IllegalArgumentException("Unexpected number of elements in a column");
            }
            vector[P.nz_rows[i]] = i;
        }
    }

    public static void permutationInverse(int[] original, int[] inverse, int length) {
        for (int i = 0; i < length; ++i) {
            inverse[original[i]] = i;
        }
    }

    public static int[] permutationInverse(int[] original, int length) {
        int[] inverse = new int[length];
        CommonOps_DSCC.permutationInverse(original, inverse, length);
        return inverse;
    }

    public static void permuteRowInv(int[] permInv, DMatrixSparseCSC input, DMatrixSparseCSC output) {
        if (input.numRows > permInv.length) {
            throw new IllegalArgumentException("permutation vector must have at least as many elements as input has rows");
        }
        output.reshape(input.numRows, input.numCols, input.nz_length);
        output.nz_length = input.nz_length;
        output.indicesSorted = false;
        System.arraycopy(input.nz_values, 0, output.nz_values, 0, input.nz_length);
        System.arraycopy(input.col_idx, 0, output.col_idx, 0, input.numCols + 1);
        int idx0 = 0;
        for (int i = 0; i < input.numCols; ++i) {
            int idx1 = output.col_idx[i + 1];
            for (int j = idx0; j < idx1; ++j) {
                output.nz_rows[j] = permInv[input.nz_rows[j]];
            }
            idx0 = idx1;
        }
    }

    public static void permute(int[] permRowInv, DMatrixSparseCSC input, int[] permCol, DMatrixSparseCSC output) {
        if (permRowInv != null && input.numRows > permRowInv.length) {
            throw new IllegalArgumentException("rowInv permutation vector must have at least as many elements as input has columns");
        }
        if (permCol != null && input.numCols > permCol.length) {
            throw new IllegalArgumentException("permCol permutation vector must have at least as many elements as input has rows");
        }
        output.reshape(input.numRows, input.numCols, input.nz_length);
        output.indicesSorted = false;
        output.nz_length = input.nz_length;
        int N = input.numCols;
        int outputNZ = 0;
        for (int i = 0; i < N; ++i) {
            int inputCol = permCol != null ? permCol[i] : i;
            int inputNZ = input.col_idx[inputCol];
            int total = input.col_idx[inputCol + 1] - inputNZ;
            output.col_idx[i + 1] = output.col_idx[i] + total;
            for (int j = 0; j < total; ++j) {
                int row = input.nz_rows[inputNZ];
                output.nz_rows[outputNZ] = permRowInv != null ? permRowInv[row] : row;
                output.nz_values[outputNZ++] = input.nz_values[inputNZ++];
            }
        }
    }

    public static void permute(int[] perm, double[] input, double[] output, int N) {
        for (int k = 0; k < N; ++k) {
            output[k] = input[perm[k]];
        }
    }

    public static void permuteInv(int[] perm, double[] input, double[] output, int N) {
        for (int k = 0; k < N; ++k) {
            output[perm[k]] = input[k];
        }
    }

    public static void permuteSymmetric(DMatrixSparseCSC input, int[] permInv, DMatrixSparseCSC output, IGrowArray gw) {
        int i2;
        int i;
        int p;
        int idx1;
        int idx0;
        int j2;
        int j;
        if (input.numRows != input.numCols) {
            throw new IllegalArgumentException("Input must be a square matrix");
        }
        if (input.numRows != permInv.length) {
            throw new IllegalArgumentException("Number of column in input must match length of permInv");
        }
        if (input.numCols != permInv.length) {
            throw new IllegalArgumentException("Number of rows in input must match length of permInv");
        }
        int N = input.numCols;
        int[] w = TriangularSolver_DSCC.adjustClear(gw, N);
        output.reshape(N, N, 0);
        output.indicesSorted = false;
        output.col_idx[0] = 0;
        for (j = 0; j < N; ++j) {
            j2 = permInv[j];
            idx0 = input.col_idx[j];
            idx1 = input.col_idx[j + 1];
            for (p = idx0; p < idx1; ++p) {
                i = input.nz_rows[p];
                if (i > j) continue;
                i2 = permInv[i];
                int n = i2 > j2 ? i2 : j2;
                w[n] = w[n] + 1;
            }
        }
        output.colsum(w);
        for (j = 0; j < N; ++j) {
            j2 = permInv[j];
            idx0 = input.col_idx[j];
            idx1 = input.col_idx[j + 1];
            for (p = idx0; p < idx1; ++p) {
                i = input.nz_rows[p];
                if (i > j) continue;
                i2 = permInv[i];
                int n = i2 > j2 ? i2 : j2;
                w[n] = w[n] + 1;
                output.nz_rows[q] = i2 < j2 ? i2 : j2;
                output.nz_values[q] = input.nz_values[p];
            }
        }
    }

    public static DMatrixSparseCSC concatRows(DMatrixSparseCSC top, DMatrixSparseCSC bottom, DMatrixSparseCSC out) {
        if (top.numCols != bottom.numCols) {
            throw new IllegalArgumentException("Number of columns must match");
        }
        if (out == null) {
            out = new DMatrixSparseCSC(0, 0, 0);
        }
        out.reshape(top.numRows + bottom.numRows, top.numCols, top.nz_length + bottom.nz_length);
        out.nz_length = top.nz_length + bottom.nz_length;
        int index = 0;
        for (int i = 0; i < top.numCols; ++i) {
            int out1;
            int top0 = top.col_idx[i];
            int top1 = top.col_idx[i + 1];
            int bot0 = bottom.col_idx[i];
            int bot1 = bottom.col_idx[i + 1];
            int out0 = out.col_idx[i];
            out.col_idx[i + 1] = out1 = out0 + top1 - top0 + bot1 - bot0;
            int j = top0;
            while (j < top1) {
                out.nz_values[index] = top.nz_values[j];
                out.nz_rows[index] = top.nz_rows[j];
                ++j;
                ++index;
            }
            j = bot0;
            while (j < bot1) {
                out.nz_values[index] = bottom.nz_values[j];
                out.nz_rows[index] = top.numRows + bottom.nz_rows[j];
                ++j;
                ++index;
            }
        }
        out.indicesSorted = false;
        return out;
    }

    public static DMatrixSparseCSC concatColumns(DMatrixSparseCSC left, DMatrixSparseCSC right, DMatrixSparseCSC out) {
        if (left.numRows != right.numRows) {
            throw new IllegalArgumentException("Number of rows must match");
        }
        if (out == null) {
            out = new DMatrixSparseCSC(0, 0, 0);
        }
        out.reshape(left.numRows, left.numCols + right.numCols, left.nz_length + right.nz_length);
        out.nz_length = left.nz_length + right.nz_length;
        System.arraycopy(left.col_idx, 0, out.col_idx, 0, left.numCols + 1);
        System.arraycopy(left.nz_rows, 0, out.nz_rows, 0, left.nz_length);
        System.arraycopy(left.nz_values, 0, out.nz_values, 0, left.nz_length);
        int index = left.nz_length;
        for (int i = 0; i < right.numCols; ++i) {
            int r0 = right.col_idx[i];
            int r1 = right.col_idx[i + 1];
            out.col_idx[left.numCols + i] = index;
            out.col_idx[left.numCols + i + 1] = index + (r1 - r0);
            int j = r0;
            while (j < r1) {
                out.nz_rows[index] = right.nz_rows[j];
                out.nz_values[index] = right.nz_values[j];
                ++j;
                ++index;
            }
        }
        out.indicesSorted = left.indicesSorted && right.indicesSorted;
        return out;
    }

    public static DMatrixSparseCSC extractColumn(DMatrixSparseCSC A, int column, DMatrixSparseCSC out) {
        if (out == null) {
            out = new DMatrixSparseCSC(1, 1, 1);
        }
        int idx0 = A.col_idx[column];
        int idx1 = A.col_idx[column + 1];
        out.reshape(A.numRows, 1, idx1 - idx0);
        out.nz_length = idx1 - idx0;
        out.col_idx[0] = 0;
        out.col_idx[1] = out.nz_length;
        System.arraycopy(A.nz_values, idx0, out.nz_values, 0, out.nz_length);
        System.arraycopy(A.nz_rows, idx0, out.nz_rows, 0, out.nz_length);
        return out;
    }

    public static DMatrixSparseCSC extractRows(DMatrixSparseCSC A, int row0, int row1, DMatrixSparseCSC out) {
        if (out == null) {
            out = new DMatrixSparseCSC(1, 1, 1);
        }
        out.reshape(row1 - row0, A.numCols, A.nz_length);
        for (int col = 0; col < A.numCols; ++col) {
            int idx0 = A.col_idx[col];
            int idx1 = A.col_idx[col + 1];
            for (int i = idx0; i < idx1; ++i) {
                int row = A.nz_rows[i];
                if (row < row0 || row >= row1) continue;
                out.nz_values[out.nz_length] = A.nz_values[i];
                out.nz_rows[out.nz_length++] = row - row0;
            }
            out.col_idx[col + 1] = out.nz_length;
        }
        return out;
    }

    public static void extract(DMatrixSparseCSC src, int srcY0, int srcY1, int srcX0, int srcX1, DMatrixSparseCSC dst, int dstY0, int dstX0) {
        if (srcY1 < srcY0 || srcY0 < 0 || srcY1 > src.getNumRows()) {
            throw new IllegalArgumentException("srcY1 < srcY0 || srcY0 < 0 || srcY1 > src.numRows");
        }
        if (srcX1 < srcX0 || srcX0 < 0 || srcX1 > src.getNumCols()) {
            throw new IllegalArgumentException("srcX1 < srcX0 || srcX0 < 0 || srcX1 > src.numCols");
        }
        int w = srcX1 - srcX0;
        int h = srcY1 - srcY0;
        if (dstY0 + h > dst.getNumRows()) {
            throw new IllegalArgumentException("dst is too small in rows");
        }
        if (dstX0 + w > dst.getNumCols()) {
            throw new IllegalArgumentException("dst is too small in columns");
        }
        CommonOps_DSCC.zero(dst, dstY0, dstY0 + h, dstX0, dstX0 + w);
        for (int colSrc = srcX0; colSrc < srcX1; ++colSrc) {
            int idxS0 = src.col_idx[colSrc];
            int idxS1 = src.col_idx[colSrc + 1];
            for (int i = idxS0; i < idxS1; ++i) {
                int row = src.nz_rows[i];
                if (row < srcY0 || row >= srcY1) continue;
                dst.set(row - srcY0 + dstY0, colSrc - srcX0 + dstX0, src.nz_values[i]);
            }
        }
    }

    public static void zero(DMatrixSparseCSC A, int row0, int row1, int col0, int col1) {
        for (int col = col1 - 1; col >= col0; --col) {
            int i;
            int numRemoved = 0;
            int idx0 = A.col_idx[col];
            int idx1 = A.col_idx[col + 1];
            for (i = idx0; i < idx1; ++i) {
                int row = A.nz_rows[i];
                if (row >= row0 && row < row1) {
                    ++numRemoved;
                    continue;
                }
                if (numRemoved <= 0) continue;
                A.nz_rows[i - numRemoved] = row;
                A.nz_values[i - numRemoved] = A.nz_values[i];
            }
            if (numRemoved <= 0) continue;
            for (i = idx1; i < A.nz_length; ++i) {
                A.nz_rows[i - numRemoved] = A.nz_rows[i];
                A.nz_values[i - numRemoved] = A.nz_values[i];
            }
            A.nz_length -= numRemoved;
            i = col + 1;
            while (i <= A.numCols) {
                int n = i++;
                A.col_idx[n] = A.col_idx[n] - numRemoved;
            }
        }
    }

    public static double dotInnerColumns(DMatrixSparseCSC A, int colA, DMatrixSparseCSC B, int colB, IGrowArray gw, DGrowArray gx) {
        return ImplSparseSparseMult_DSCC.dotInnerColumns(A, colA, B, colB, gw, gx);
    }

    public static boolean solve(DMatrixSparseCSC a, DMatrixRMaj b, DMatrixRMaj x) {
        LinearSolverSparse<DMatrixSparseCSC, DMatrixRMaj> solver = a.numRows > a.numCols ? LinearSolverFactory_DSCC.qr(FillReducing.NONE) : LinearSolverFactory_DSCC.lu(FillReducing.NONE);
        if (solver.modifiesA()) {
            a = a.copy();
        }
        if (solver.modifiesB()) {
            b = b.copy();
        }
        if (!solver.setA((Matrix)a)) {
            return false;
        }
        solver.solve((Matrix)b, (Matrix)x);
        return true;
    }

    public static boolean invert(DMatrixSparseCSC A, DMatrixRMaj inverse) {
        if (A.numRows != A.numCols) {
            throw new IllegalArgumentException("A must be a square matrix");
        }
        if (A.numRows != inverse.numRows || A.numCols != inverse.numCols) {
            throw new IllegalArgumentException("A and inverse must have the same shape.");
        }
        LinearSolverSparse<DMatrixSparseCSC, DMatrixRMaj> solver = LinearSolverFactory_DSCC.lu(FillReducing.NONE);
        if (solver.modifiesA()) {
            A = A.copy();
        }
        DMatrixRMaj I = CommonOps_DDRM.identity((int)A.numRows);
        if (!solver.setA((Matrix)A)) {
            return false;
        }
        solver.solve((Matrix)I, (Matrix)inverse);
        return true;
    }

    public static double det(DMatrixSparseCSC A) {
        LUSparseDecomposition_F64<DMatrixSparseCSC> alg = DecompositionFactory_DSCC.lu(FillReducing.NONE);
        if (alg.inputModified()) {
            A = A.copy();
        }
        if (!alg.decompose((Matrix)A)) {
            return 0.0;
        }
        return alg.computeDeterminant().real;
    }

    public static void removeZeros(DMatrixSparseCSC input, DMatrixSparseCSC output, double tol) {
        ImplCommonOps_DSCC.removeZeros(input, output, tol);
    }

    public static void removeZeros(DMatrixSparseCSC A, double tol) {
        ImplCommonOps_DSCC.removeZeros(A, tol);
    }

    public static double trace(DMatrixSparseCSC A) {
        double output = 0.0;
        int o = Math.min(A.numCols, A.numRows);
        block0: for (int col = 0; col < o; ++col) {
            int idx0 = A.col_idx[col];
            int idx1 = A.col_idx[col + 1];
            for (int i = idx0; i < idx1; ++i) {
                if (A.nz_rows[i] != col) continue;
                output += A.nz_values[i];
                continue block0;
            }
        }
        return output;
    }
}

