/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.sparse.csc;

import org.ejml.MatrixDimensionException;
import org.ejml.UtilEjml;
import org.ejml.data.DGrowArray;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.Matrix;
import org.ejml.data.ReshapeMatrix;
import org.ejml.sparse.csc.misc.ImplCommonOps_MT_DSCC;
import org.ejml.sparse.csc.mult.ImplMultiplication_MT_DSCC;
import org.ejml.sparse.csc.mult.Workspace_MT_DSCC;
import org.jetbrains.annotations.Nullable;
import pabeles.concurrency.GrowArray;

public class CommonOps_MT_DSCC {
    private CommonOps_MT_DSCC() {
    }

    public static DMatrixSparseCSC mult(DMatrixSparseCSC A, DMatrixSparseCSC B, @Nullable DMatrixSparseCSC outputC) {
        return CommonOps_MT_DSCC.mult(A, B, outputC, null);
    }

    public static DMatrixSparseCSC mult(DMatrixSparseCSC A, DMatrixSparseCSC B, @Nullable DMatrixSparseCSC outputC, @Nullable GrowArray<Workspace_MT_DSCC> workspace) {
        if (A.numCols != B.numRows) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes((Matrix)A, (Matrix)B));
        }
        outputC = (DMatrixSparseCSC)UtilEjml.reshapeOrDeclare((ReshapeMatrix)outputC, (ReshapeMatrix)A, (int)A.numRows, (int)B.numCols);
        if (workspace == null) {
            workspace = new GrowArray(Workspace_MT_DSCC::new);
        }
        ImplMultiplication_MT_DSCC.mult(A, B, outputC, (GrowArray<Workspace_MT_DSCC>)workspace);
        return outputC;
    }

    public static DMatrixSparseCSC add(double alpha, DMatrixSparseCSC A, double beta, DMatrixSparseCSC B, @Nullable DMatrixSparseCSC outputC, @Nullable GrowArray<Workspace_MT_DSCC> workspace) {
        if (A.numRows != B.numRows || A.numCols != B.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes((Matrix)A, (Matrix)B));
        }
        outputC = (DMatrixSparseCSC)UtilEjml.reshapeOrDeclare((ReshapeMatrix)outputC, (ReshapeMatrix)A, (int)A.numRows, (int)A.numCols);
        if (workspace == null) {
            workspace = new GrowArray(Workspace_MT_DSCC::new);
        }
        ImplCommonOps_MT_DSCC.add(alpha, A, beta, B, outputC, (GrowArray<Workspace_MT_DSCC>)workspace);
        return outputC;
    }

    public static DMatrixRMaj mult(DMatrixSparseCSC A, DMatrixRMaj B, @Nullable DMatrixRMaj outputC, @Nullable GrowArray<DGrowArray> workspace) {
        if (A.numCols != B.numRows) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes((Matrix)A, (Matrix)B));
        }
        outputC = UtilEjml.reshapeOrDeclare((DMatrixRMaj)outputC, (int)A.numRows, (int)B.numCols);
        if (workspace == null) {
            workspace = new GrowArray(DGrowArray::new);
        }
        ImplMultiplication_MT_DSCC.mult(A, B, outputC, (GrowArray<DGrowArray>)workspace);
        return outputC;
    }

    public static void multAdd(DMatrixSparseCSC A, DMatrixRMaj B, DMatrixRMaj outputC, @Nullable GrowArray<DGrowArray> workspace) {
        if (A.numCols != B.numRows) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes((Matrix)A, (Matrix)B));
        }
        if (A.numRows != outputC.numRows || B.numCols != outputC.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes((Matrix)A, (Matrix)B, (Matrix)outputC));
        }
        if (workspace == null) {
            workspace = new GrowArray(DGrowArray::new);
        }
        ImplMultiplication_MT_DSCC.multAdd(A, B, outputC, (GrowArray<DGrowArray>)workspace);
    }

    public static DMatrixRMaj multTransA(DMatrixSparseCSC A, DMatrixRMaj B, @Nullable DMatrixRMaj outputC, @Nullable GrowArray<DGrowArray> workspace) {
        if (A.numRows != B.numRows) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes((Matrix)A, (Matrix)B));
        }
        outputC = UtilEjml.reshapeOrDeclare((DMatrixRMaj)outputC, (int)A.numCols, (int)B.numCols);
        if (workspace == null) {
            workspace = new GrowArray(DGrowArray::new);
        }
        ImplMultiplication_MT_DSCC.multTransA(A, B, outputC, (GrowArray<DGrowArray>)workspace);
        return outputC;
    }

    public static void multAddTransA(DMatrixSparseCSC A, DMatrixRMaj B, DMatrixRMaj outputC, @Nullable GrowArray<DGrowArray> workspace) {
        if (A.numRows != B.numRows) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes((Matrix)A, (Matrix)B));
        }
        if (A.numCols != outputC.numRows || B.numCols != outputC.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes((Matrix)A, (Matrix)B, (Matrix)outputC));
        }
        if (workspace == null) {
            workspace = new GrowArray(DGrowArray::new);
        }
        ImplMultiplication_MT_DSCC.multAddTransA(A, B, outputC, (GrowArray<DGrowArray>)workspace);
    }

    public static DMatrixRMaj multTransB(DMatrixSparseCSC A, DMatrixRMaj B, @Nullable DMatrixRMaj outputC, @Nullable GrowArray<DGrowArray> workspace) {
        if (A.numCols != B.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes((Matrix)A, (Matrix)B));
        }
        outputC = UtilEjml.reshapeOrDeclare((DMatrixRMaj)outputC, (int)A.numRows, (int)B.numRows);
        if (workspace == null) {
            workspace = new GrowArray(DGrowArray::new);
        }
        ImplMultiplication_MT_DSCC.multTransB(A, B, outputC, (GrowArray<DGrowArray>)workspace);
        return outputC;
    }

    public static void multAddTransB(DMatrixSparseCSC A, DMatrixRMaj B, DMatrixRMaj outputC, @Nullable GrowArray<DGrowArray> workspace) {
        if (A.numCols != B.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes((Matrix)A, (Matrix)B));
        }
        if (A.numRows != outputC.numRows || B.numRows != outputC.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes((Matrix)A, (Matrix)B, (Matrix)outputC));
        }
        if (workspace == null) {
            workspace = new GrowArray(DGrowArray::new);
        }
        ImplMultiplication_MT_DSCC.multAddTransB(A, B, outputC, (GrowArray<DGrowArray>)workspace);
    }

    public static DMatrixRMaj multTransAB(DMatrixSparseCSC A, DMatrixRMaj B, DMatrixRMaj outputC) {
        if (A.numRows != B.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes((Matrix)A, (Matrix)B));
        }
        outputC = UtilEjml.reshapeOrDeclare((DMatrixRMaj)outputC, (int)A.numCols, (int)B.numRows);
        ImplMultiplication_MT_DSCC.multTransAB(A, B, outputC);
        return outputC;
    }

    public static void multAddTransAB(DMatrixSparseCSC A, DMatrixRMaj B, DMatrixRMaj outputC) {
        if (A.numRows != B.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes((Matrix)A, (Matrix)B));
        }
        if (A.numCols != outputC.numRows || B.numRows != outputC.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes((Matrix)A, (Matrix)B, (Matrix)outputC));
        }
        ImplMultiplication_MT_DSCC.multAddTransAB(A, B, outputC);
    }
}

