/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.simple;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import org.ejml.UtilEjml;
import org.ejml.data.CMatrixRMaj;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixIterator;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.FMatrix;
import org.ejml.data.FMatrix1Row;
import org.ejml.data.FMatrixD1;
import org.ejml.data.FMatrixRMaj;
import org.ejml.data.FMatrixSparseCSC;
import org.ejml.data.Matrix;
import org.ejml.data.MatrixType;
import org.ejml.data.ReshapeMatrix;
import org.ejml.data.SingularMatrixException;
import org.ejml.data.ZMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.CommonOps_FDRM;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.ejml.dense.row.MatrixFeatures_FDRM;
import org.ejml.dense.row.SpecializedOps_DDRM;
import org.ejml.dense.row.SpecializedOps_FDRM;
import org.ejml.dense.row.mult.VectorVectorMult_DDRM;
import org.ejml.dense.row.mult.VectorVectorMult_FDRM;
import org.ejml.equation.Equation;
import org.ejml.ops.MatrixIO;
import org.ejml.simple.SimpleEVD;
import org.ejml.simple.SimpleMatrix;
import org.ejml.simple.SimpleOperations;
import org.ejml.simple.SimpleSVD;
import org.ejml.simple.ops.SimpleOperations_CDRM;
import org.ejml.simple.ops.SimpleOperations_DDRM;
import org.ejml.simple.ops.SimpleOperations_FDRM;
import org.ejml.simple.ops.SimpleOperations_SPARSE;
import org.ejml.simple.ops.SimpleOperations_ZDRM;

public abstract class SimpleBase<T extends SimpleBase>
implements Serializable {
    static final long serialVersionUID = 2342556642L;
    protected Matrix mat;
    protected SimpleOperations ops;

    public SimpleBase(int numRows, int numCols) {
        this.setMatrix((Matrix)new DMatrixRMaj(numRows, numCols));
    }

    protected SimpleBase() {
    }

    protected abstract T createMatrix(int var1, int var2, MatrixType var3);

    protected abstract T wrapMatrix(Matrix var1);

    public <T extends Matrix> T getMatrix() {
        return (T)this.mat;
    }

    public DMatrixRMaj getDDRM() {
        return (DMatrixRMaj)this.mat;
    }

    public FMatrixRMaj getFDRM() {
        return (FMatrixRMaj)this.mat;
    }

    public ZMatrixRMaj getZDRM() {
        return (ZMatrixRMaj)this.mat;
    }

    public CMatrixRMaj getCDRM() {
        return (CMatrixRMaj)this.mat;
    }

    public DMatrixSparseCSC getDSCC() {
        return (DMatrixSparseCSC)this.mat;
    }

    public FMatrixSparseCSC getFSCC() {
        return (FMatrixSparseCSC)this.mat;
    }

    protected SimpleOperations lookupOps(MatrixType type) {
        switch (type) {
            case DDRM: {
                return new SimpleOperations_DDRM();
            }
            case FDRM: {
                return new SimpleOperations_FDRM();
            }
            case ZDRM: {
                return new SimpleOperations_ZDRM();
            }
            case CDRM: {
                return new SimpleOperations_CDRM();
            }
            case DSCC: {
                return new SimpleOperations_SPARSE();
            }
        }
        throw new RuntimeException("Unknown Matrix Type");
    }

    public T transpose() {
        T ret = this.createMatrix(this.mat.getNumCols(), this.mat.getNumRows(), this.mat.getType());
        this.ops.transpose(this.mat, ((SimpleBase)ret).mat);
        return ret;
    }

    public T mult(T b) {
        T ret = this.createMatrix(this.mat.getNumRows(), ((SimpleBase)b).getMatrix().getNumCols(), this.mat.getType());
        this.ops.mult(this.mat, ((SimpleBase)b).mat, ((SimpleBase)ret).mat);
        return ret;
    }

    public T kron(T B) {
        T ret = this.createMatrix(this.mat.getNumRows() * ((SimpleBase)B).numRows(), this.mat.getNumCols() * ((SimpleBase)B).numCols(), this.mat.getType());
        this.ops.kron(this.mat, ((SimpleBase)B).mat, ((SimpleBase)ret).mat);
        return ret;
    }

    public T plus(T b) {
        T ret = this.createMatrix(this.mat.getNumRows(), this.mat.getNumCols(), this.mat.getType());
        this.ops.plus(this.mat, ((SimpleBase)b).mat, ((SimpleBase)ret).mat);
        return ret;
    }

    public T minus(T b) {
        T ret = this.createMatrix(this.mat.getNumRows(), this.mat.getNumCols(), this.mat.getType());
        this.ops.minus(this.mat, ((SimpleBase)b).mat, ((SimpleBase)ret).mat);
        return ret;
    }

    public T minus(double b) {
        T ret = this.copy();
        if (this.bits() == 64) {
            CommonOps_DDRM.subtract((DMatrixD1)((DMatrixRMaj)this.getMatrix()), (double)b, (DMatrixD1)((DMatrixRMaj)((SimpleBase)ret).getMatrix()));
        } else {
            CommonOps_FDRM.subtract((FMatrixD1)((FMatrixRMaj)this.getMatrix()), (float)((float)b), (FMatrixD1)((FMatrixRMaj)((SimpleBase)ret).getMatrix()));
        }
        return ret;
    }

    public T plus(double b) {
        T ret = this.createMatrix(this.numRows(), this.numCols(), this.mat.getType());
        if (this.bits() == 64) {
            CommonOps_DDRM.add((DMatrixD1)((DMatrixRMaj)this.getMatrix()), (double)b, (DMatrixD1)((DMatrixRMaj)((SimpleBase)ret).getMatrix()));
        } else {
            CommonOps_FDRM.add((FMatrixD1)((FMatrixRMaj)this.getMatrix()), (float)((float)b), (FMatrixD1)((FMatrixRMaj)((SimpleBase)ret).getMatrix()));
        }
        return ret;
    }

    public T plus(double beta, T b) {
        T ret = this.copy();
        if (this.bits() == 64) {
            CommonOps_DDRM.addEquals((DMatrixD1)((DMatrixRMaj)((SimpleBase)ret).getMatrix()), (double)beta, (DMatrixD1)((DMatrixRMaj)((SimpleBase)b).getMatrix()));
        } else {
            CommonOps_FDRM.addEquals((FMatrixD1)((FMatrixRMaj)((SimpleBase)ret).getMatrix()), (float)((float)beta), (FMatrixD1)((FMatrixRMaj)((SimpleBase)b).getMatrix()));
        }
        return ret;
    }

    public double dot(T v) {
        if (!this.isVector()) {
            throw new IllegalArgumentException("'this' matrix is not a vector.");
        }
        if (!((SimpleBase)v).isVector()) {
            throw new IllegalArgumentException("'v' matrix is not a vector.");
        }
        if (this.bits() == 64) {
            return VectorVectorMult_DDRM.innerProd((DMatrixD1)((DMatrixRMaj)this.mat), (DMatrixD1)((DMatrixRMaj)((SimpleBase)v).getMatrix()));
        }
        return VectorVectorMult_FDRM.innerProd((FMatrixD1)((FMatrixRMaj)this.mat), (FMatrixD1)((FMatrixRMaj)((SimpleBase)v).getMatrix()));
    }

    public boolean isVector() {
        return this.mat.getNumRows() == 1 || this.mat.getNumCols() == 1;
    }

    public T scale(double val) {
        T ret = this.copy();
        if (this.bits() == 64) {
            CommonOps_DDRM.scale((double)val, (DMatrixD1)((DMatrixRMaj)((SimpleBase)ret).getMatrix()));
        } else {
            CommonOps_FDRM.scale((float)((float)val), (FMatrixD1)((FMatrixRMaj)((SimpleBase)ret).getMatrix()));
        }
        return ret;
    }

    public T divide(double val) {
        T ret = this.copy();
        if (this.bits() == 64) {
            CommonOps_DDRM.divide((DMatrixD1)((DMatrixRMaj)((SimpleBase)ret).getMatrix()), (double)val);
        } else {
            CommonOps_FDRM.divide((FMatrixD1)((FMatrixRMaj)((SimpleBase)ret).getMatrix()), (float)((float)val));
        }
        return ret;
    }

    public T invert() {
        T ret = this.createMatrix(this.mat.getNumRows(), this.mat.getNumCols(), this.mat.getType());
        if (!this.ops.invert(this.mat, ((SimpleBase)ret).mat)) {
            throw new SingularMatrixException();
        }
        if (this.ops.hasUncountable(((SimpleBase)ret).mat)) {
            throw new SingularMatrixException("Solution contains uncountable numbers");
        }
        return ret;
    }

    public T pseudoInverse() {
        T ret = this.createMatrix(this.mat.getNumCols(), this.mat.getNumRows(), this.mat.getType());
        if (this.bits() == 64) {
            CommonOps_DDRM.pinv((DMatrixRMaj)((DMatrixRMaj)this.mat), (DMatrixRMaj)((DMatrixRMaj)((SimpleBase)ret).getMatrix()));
        } else {
            CommonOps_FDRM.pinv((FMatrixRMaj)((FMatrixRMaj)this.mat), (FMatrixRMaj)((FMatrixRMaj)((SimpleBase)ret).getMatrix()));
        }
        return ret;
    }

    public T solve(T b) {
        T x = this.createMatrix(this.mat.getNumCols(), ((SimpleBase)b).getMatrix().getNumCols(), this.mat.getType());
        if (!this.ops.solve(this.mat, ((SimpleBase)x).mat, ((SimpleBase)b).mat)) {
            throw new SingularMatrixException();
        }
        if (this.ops.hasUncountable(((SimpleBase)x).mat)) {
            throw new SingularMatrixException("Solution contains uncountable numbers");
        }
        return x;
    }

    public void set(T a) {
        this.mat.set(((SimpleBase)a).getMatrix());
    }

    public void set(double val) {
        if (this.bits() == 64) {
            CommonOps_DDRM.fill((DMatrixD1)((DMatrixRMaj)this.mat), (double)val);
        } else {
            CommonOps_FDRM.fill((FMatrixD1)((FMatrixRMaj)this.mat), (float)((float)val));
        }
    }

    public void zero() {
        if (this.bits() == 64) {
            ((DMatrixRMaj)this.mat).zero();
        } else {
            ((FMatrixRMaj)this.mat).zero();
        }
    }

    public double normF() {
        return this.ops.normF(this.mat);
    }

    public double conditionP2() {
        return this.ops.conditionP2(this.mat);
    }

    public double determinant() {
        double ret = this.ops.determinant(this.mat);
        if (UtilEjml.isUncountable((double)ret)) {
            return 0.0;
        }
        return ret;
    }

    public double trace() {
        return this.ops.trace(this.mat);
    }

    public void reshape(int numRows, int numCols) {
        if (this.mat.getType().isFixed()) {
            throw new IllegalArgumentException("Can't rename a fixed sized matrix");
        }
        ((ReshapeMatrix)this.mat).reshape(numRows, numCols);
    }

    public void set(int row, int col, double value) {
        if (this.bits() == 64) {
            ((DMatrixRMaj)this.mat).set(row, col, value);
        } else {
            ((FMatrixRMaj)this.mat).set(row, col, (float)value);
        }
    }

    public void set(int index, double value) {
        if (this.bits() == 64) {
            ((DMatrixRMaj)this.mat).set(index, value);
        } else {
            ((FMatrixRMaj)this.mat).set(index, (float)value);
        }
    }

    public void setRow(int row, int startColumn, double ... values) {
        this.ops.setRow(this.mat, row, startColumn, values);
    }

    public void setColumn(int column, int startRow, double ... values) {
        this.ops.setColumn(this.mat, column, startRow, values);
    }

    public double get(int row, int col) {
        if (this.mat.getType().getBits() == 64) {
            return ((DMatrix)this.mat).get(row, col);
        }
        return ((FMatrix)this.mat).get(row, col);
    }

    public double get(int index) {
        if (this.bits() == 64) {
            return ((DMatrixRMaj)this.mat).data[index];
        }
        return ((FMatrixRMaj)this.mat).data[index];
    }

    public int getIndex(int row, int col) {
        return row * this.mat.getNumCols() + col;
    }

    public DMatrixIterator iterator(boolean rowMajor, int minRow, int minCol, int maxRow, int maxCol) {
        return new DMatrixIterator((DMatrixD1)((DMatrixRMaj)this.mat), rowMajor, minRow, minCol, maxRow, maxCol);
    }

    public T copy() {
        T ret = this.createMatrix(this.mat.getNumRows(), this.mat.getNumCols(), this.mat.getType());
        ((SimpleBase)ret).getMatrix().set(this.getMatrix());
        return ret;
    }

    public int numRows() {
        return this.mat.getNumRows();
    }

    public int numCols() {
        return this.mat.getNumCols();
    }

    public int getNumElements() {
        if (this.bits() == 64) {
            return ((DMatrixRMaj)this.mat).getNumElements();
        }
        return ((FMatrixRMaj)this.mat).getNumElements();
    }

    public void print() {
        this.ops.print(System.out, this.mat);
    }

    public void print(int numChar, int precision) {
        if (this.bits() == 64) {
            MatrixIO.print((PrintStream)System.out, (DMatrix)((DMatrixRMaj)this.mat), (int)numChar, (int)precision);
        } else {
            MatrixIO.print((PrintStream)System.out, (FMatrix)((FMatrixRMaj)this.mat), (int)numChar, (int)precision);
        }
    }

    public void print(String format) {
        if (this.bits() == 64) {
            MatrixIO.print((PrintStream)System.out, (DMatrix)((DMatrixRMaj)this.mat), (String)format);
        } else {
            MatrixIO.print((PrintStream)System.out, (FMatrix)((FMatrixRMaj)this.mat), (String)format);
        }
    }

    public String toString() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        if (this.bits() == 64) {
            MatrixIO.print((PrintStream)new PrintStream(stream), (DMatrix)((DMatrixRMaj)this.mat));
        } else {
            MatrixIO.print((PrintStream)new PrintStream(stream), (FMatrix)((FMatrixRMaj)this.mat));
        }
        return stream.toString();
    }

    public T extractMatrix(int y0, int y1, int x0, int x1) {
        if (y0 == Integer.MAX_VALUE) {
            y0 = this.mat.getNumRows();
        }
        if (y1 == Integer.MAX_VALUE) {
            y1 = this.mat.getNumRows();
        }
        if (x0 == Integer.MAX_VALUE) {
            x0 = this.mat.getNumCols();
        }
        if (x1 == Integer.MAX_VALUE) {
            x1 = this.mat.getNumCols();
        }
        T ret = this.createMatrix(y1 - y0, x1 - x0, this.mat.getType());
        this.ops.extract(this.mat, y0, y1, x0, x1, ((SimpleBase)ret).mat, 0, 0);
        return ret;
    }

    public T extractVector(boolean extractRow, int element) {
        T ret;
        int length = extractRow ? this.mat.getNumCols() : this.mat.getNumRows();
        T t = ret = extractRow ? this.createMatrix(1, length, this.mat.getType()) : this.createMatrix(length, 1, this.mat.getType());
        if (this.bits() == 64) {
            if (extractRow) {
                SpecializedOps_DDRM.subvector((DMatrix1Row)((DMatrixRMaj)this.mat), (int)element, (int)0, (int)length, (boolean)true, (int)0, (DMatrix1Row)((DMatrixRMaj)((SimpleBase)ret).getMatrix()));
            } else {
                SpecializedOps_DDRM.subvector((DMatrix1Row)((DMatrixRMaj)this.mat), (int)0, (int)element, (int)length, (boolean)false, (int)0, (DMatrix1Row)((DMatrixRMaj)((SimpleBase)ret).getMatrix()));
            }
        } else if (extractRow) {
            SpecializedOps_FDRM.subvector((FMatrix1Row)((FMatrixRMaj)this.mat), (int)element, (int)0, (int)length, (boolean)true, (int)0, (FMatrix1Row)((FMatrixRMaj)((SimpleBase)ret).getMatrix()));
        } else {
            SpecializedOps_FDRM.subvector((FMatrix1Row)((FMatrixRMaj)this.mat), (int)0, (int)element, (int)length, (boolean)false, (int)0, (FMatrix1Row)((FMatrixRMaj)((SimpleBase)ret).getMatrix()));
        }
        return ret;
    }

    public T diag() {
        T diag;
        if (this.bits() == 64) {
            if (MatrixFeatures_DDRM.isVector((Matrix)this.mat)) {
                int N = Math.max(this.mat.getNumCols(), this.mat.getNumRows());
                diag = this.createMatrix(N, N, this.mat.getType());
                CommonOps_DDRM.diag((DMatrixRMaj)((DMatrixRMaj)((SimpleBase)diag).getMatrix()), (int)N, (double[])((DMatrixRMaj)this.mat).data);
            } else {
                int N = Math.min(this.mat.getNumCols(), this.mat.getNumRows());
                diag = this.createMatrix(N, 1, this.mat.getType());
                CommonOps_DDRM.extractDiag((DMatrixRMaj)((DMatrixRMaj)this.mat), (DMatrixRMaj)((DMatrixRMaj)((SimpleBase)diag).getMatrix()));
            }
        } else if (MatrixFeatures_FDRM.isVector((Matrix)this.mat)) {
            int N = Math.max(this.mat.getNumCols(), this.mat.getNumRows());
            diag = this.createMatrix(N, N, this.mat.getType());
            CommonOps_FDRM.diag((FMatrixRMaj)((FMatrixRMaj)((SimpleBase)diag).getMatrix()), (int)N, (float[])((FMatrixRMaj)this.mat).data);
        } else {
            int N = Math.min(this.mat.getNumCols(), this.mat.getNumRows());
            diag = this.createMatrix(N, 1, this.mat.getType());
            CommonOps_FDRM.extractDiag((FMatrixRMaj)((FMatrixRMaj)this.mat), (FMatrixRMaj)((FMatrixRMaj)((SimpleBase)diag).getMatrix()));
        }
        return diag;
    }

    public boolean isIdentical(T a, double tol) {
        if (this.bits() == 64) {
            return MatrixFeatures_DDRM.isIdentical((DMatrixD1)((DMatrixRMaj)this.mat), (DMatrixD1)((DMatrixRMaj)((SimpleBase)a).getMatrix()), (double)tol);
        }
        return MatrixFeatures_FDRM.isIdentical((FMatrixD1)((FMatrixRMaj)this.mat), (FMatrixD1)((FMatrixRMaj)((SimpleBase)a).getMatrix()), (float)((float)tol));
    }

    public boolean hasUncountable() {
        return this.ops.hasUncountable(this.mat);
    }

    public SimpleSVD<T> svd() {
        return new SimpleSVD(this.mat, false);
    }

    public SimpleSVD<T> svd(boolean compact) {
        return new SimpleSVD(this.mat, compact);
    }

    public SimpleEVD<T> eig() {
        return new SimpleEVD(this.mat);
    }

    public void insertIntoThis(int insertRow, int insertCol, T B) {
        if (this.bits() == 64) {
            CommonOps_DDRM.insert((DMatrix)((DMatrixRMaj)((SimpleBase)B).getMatrix()), (DMatrix)((DMatrixRMaj)this.mat), (int)insertRow, (int)insertCol);
        } else {
            CommonOps_FDRM.insert((FMatrix)((FMatrixRMaj)((SimpleBase)B).getMatrix()), (FMatrix)((FMatrixRMaj)this.mat), (int)insertRow, (int)insertCol);
        }
    }

    public T combine(int insertRow, int insertCol, T B) {
        SimpleBase<T> ret;
        if (insertRow == Integer.MAX_VALUE) {
            insertRow = this.mat.getNumRows();
        }
        if (insertCol == Integer.MAX_VALUE) {
            insertCol = this.mat.getNumCols();
        }
        int maxRow = insertRow + ((SimpleBase)B).numRows();
        int maxCol = insertCol + ((SimpleBase)B).numCols();
        if (maxRow > this.mat.getNumRows() || maxCol > this.mat.getNumCols()) {
            int M = Math.max(maxRow, this.mat.getNumRows());
            int N = Math.max(maxCol, this.mat.getNumCols());
            ret = this.createMatrix(M, N, this.mat.getType());
            ret.insertIntoThis(0, 0, (SimpleBase)this);
        } else {
            ret = this.copy();
        }
        ret.insertIntoThis(insertRow, insertCol, B);
        return (T)ret;
    }

    public double elementMaxAbs() {
        return this.ops.elementMaxAbs(this.mat);
    }

    public double elementSum() {
        return this.ops.elementSum(this.mat);
    }

    public T elementMult(T b) {
        T c = this.createMatrix(this.mat.getNumRows(), this.mat.getNumCols(), this.mat.getType());
        this.ops.elementMult(this.mat, ((SimpleBase)b).mat, ((SimpleBase)c).mat);
        return c;
    }

    public T elementDiv(T b) {
        T c = this.createMatrix(this.mat.getNumRows(), this.mat.getNumCols(), this.mat.getType());
        this.ops.elementDiv(this.mat, ((SimpleBase)b).mat, ((SimpleBase)c).mat);
        return c;
    }

    public T elementPower(T b) {
        T c = this.createMatrix(this.mat.getNumRows(), this.mat.getNumCols(), this.mat.getType());
        this.ops.elementPower(this.mat, ((SimpleBase)b).mat, ((SimpleBase)c).mat);
        return c;
    }

    public T elementPower(double b) {
        T c = this.createMatrix(this.mat.getNumRows(), this.mat.getNumCols(), this.mat.getType());
        this.ops.elementPower(this.mat, b, ((SimpleBase)c).mat);
        return c;
    }

    public T elementExp() {
        T c = this.createMatrix(this.mat.getNumRows(), this.mat.getNumCols(), this.mat.getType());
        this.ops.elementExp(this.mat, ((SimpleBase)c).mat);
        return c;
    }

    public T elementLog() {
        T c = this.createMatrix(this.mat.getNumRows(), this.mat.getNumCols(), this.mat.getType());
        this.ops.elementLog(this.mat, ((SimpleBase)c).mat);
        return c;
    }

    public T negative() {
        T A = this.copy();
        this.ops.changeSign(((SimpleBase)A).mat);
        return A;
    }

    public void equation(String equation, Object ... variables) {
        if (variables.length >= 25) {
            throw new IllegalArgumentException("Too many variables!  At most 25");
        }
        if (!(this.mat instanceof DMatrixRMaj)) {
            return;
        }
        Equation eq = new Equation();
        String nameThis = "A";
        int offset = 0;
        if (variables.length > 0 && variables[0] instanceof String) {
            nameThis = (String)variables[0];
            offset = 1;
            if (variables.length % 2 != 1) {
                throw new IllegalArgumentException("Expected and odd length for variables");
            }
        } else if (variables.length % 2 != 0) {
            throw new IllegalArgumentException("Expected and even length for variables");
        }
        eq.alias((DMatrixRMaj)this.mat, nameThis);
        for (int i = offset; i < variables.length; i += 2) {
            if (!(variables[i + 1] instanceof String)) {
                throw new IllegalArgumentException("String expected at variables index " + i);
            }
            Object o = variables[i];
            String name = (String)variables[i + 1];
            if (SimpleBase.class.isAssignableFrom(o.getClass())) {
                eq.alias(((SimpleBase)o).getDDRM(), name);
                continue;
            }
            if (o instanceof DMatrixRMaj) {
                eq.alias((DMatrixRMaj)o, name);
                continue;
            }
            if (o instanceof Double) {
                eq.alias((Double)o, name);
                continue;
            }
            if (o instanceof Integer) {
                eq.alias((Integer)o, name);
                continue;
            }
            String type = o == null ? "null" : o.getClass().getSimpleName();
            throw new IllegalArgumentException("Variable type not supported by Equation! " + type);
        }
        if (!equation.contains("=")) {
            equation = nameThis + " = " + equation;
        }
        eq.process(equation);
    }

    public void saveToFileBinary(String fileName) throws IOException {
        MatrixIO.saveBin((DMatrix)((DMatrixRMaj)this.mat), (String)fileName);
    }

    public static SimpleMatrix loadBinary(String fileName) throws IOException {
        DMatrix mat = MatrixIO.loadBin((String)fileName);
        if (mat instanceof DMatrixRMaj) {
            return SimpleMatrix.wrap((Matrix)((DMatrixRMaj)mat));
        }
        return SimpleMatrix.wrap((Matrix)new DMatrixRMaj(mat));
    }

    public void saveToFileCSV(String fileName) throws IOException {
        MatrixIO.saveCSV((DMatrix)((DMatrixRMaj)this.mat), (String)fileName);
    }

    public T loadCSV(String fileName) throws IOException {
        DMatrixRMaj mat = MatrixIO.loadCSV((String)fileName);
        T ret = this.createMatrix(1, 1, mat.getType());
        ((SimpleBase)ret).setMatrix((Matrix)mat);
        return ret;
    }

    public boolean isInBounds(int row, int col) {
        return row >= 0 && col >= 0 && row < this.mat.getNumRows() && col < this.mat.getNumCols();
    }

    public void printDimensions() {
        System.out.println("[rows = " + this.numRows() + " , cols = " + this.numCols() + " ]");
    }

    public int bits() {
        return this.mat.getType().getBits();
    }

    public T concatColumns(SimpleBase ... A) {
        DMatrixRMaj combined;
        if (this.mat.getClass() == DMatrixRMaj.class) {
            DMatrixRMaj[] m = new DMatrixRMaj[A.length + 1];
            m[0] = (DMatrixRMaj)this.mat;
            for (int i = 0; i < A.length; ++i) {
                m[1] = A[i].getDDRM();
            }
            combined = CommonOps_DDRM.concatColumns((DMatrixRMaj[])m);
        } else if (this.mat.getClass() == FMatrixRMaj.class) {
            FMatrixRMaj[] m = new FMatrixRMaj[A.length + 1];
            m[0] = (FMatrixRMaj)this.mat;
            for (int i = 0; i < A.length; ++i) {
                m[1] = A[i].getFDRM();
            }
            combined = CommonOps_FDRM.concatColumns((FMatrixRMaj[])m);
        } else {
            throw new RuntimeException("Unknown matrix type");
        }
        return this.wrapMatrix((Matrix)combined);
    }

    public T concatRows(SimpleBase ... A) {
        DMatrixRMaj combined;
        if (this.mat.getClass() == DMatrixRMaj.class) {
            DMatrixRMaj[] m = new DMatrixRMaj[A.length + 1];
            m[0] = (DMatrixRMaj)this.mat;
            for (int i = 0; i < A.length; ++i) {
                m[1] = A[i].getDDRM();
            }
            combined = CommonOps_DDRM.concatRows((DMatrixRMaj[])m);
        } else if (this.mat.getClass() == FMatrixRMaj.class) {
            FMatrixRMaj[] m = new FMatrixRMaj[A.length + 1];
            m[0] = (FMatrixRMaj)this.mat;
            for (int i = 0; i < A.length; ++i) {
                m[1] = A[i].getFDRM();
            }
            combined = CommonOps_FDRM.concatRows((FMatrixRMaj[])m);
        } else {
            throw new RuntimeException("Unknown matrix type");
        }
        return this.wrapMatrix((Matrix)combined);
    }

    public T rows(int begin, int end) {
        return this.extractMatrix(begin, end, 0, Integer.MAX_VALUE);
    }

    public T cols(int begin, int end) {
        return this.extractMatrix(0, Integer.MAX_VALUE, begin, end);
    }

    public MatrixType getType() {
        return this.mat.getType();
    }

    protected void setMatrix(Matrix mat) {
        this.mat = mat;
        this.ops = this.lookupOps(mat.getType());
    }
}

