/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.simple;

import org.ejml.data.Matrix;
import org.ejml.data.MatrixType;
import org.ejml.ops.ConvertMatrixType;
import org.ejml.simple.ConstMatrix;
import org.ejml.simple.SimpleBase;

public class AutomaticSimpleMatrixConvert {
    MatrixType commonType;

    public void specify0(ConstMatrix<?> a, ConstMatrix<?> ... inputs) {
        ConstMatrix[] array = new ConstMatrix[inputs.length + 1];
        System.arraycopy(inputs, 0, array, 0, inputs.length);
        array[inputs.length] = a;
        this.specify(array);
    }

    public void specify(ConstMatrix<?> ... inputs) {
        boolean dense = false;
        boolean real = true;
        int bits = 32;
        for (ConstMatrix<?> s : inputs) {
            MatrixType t = s.getType();
            if (t.isDense()) {
                dense = true;
            }
            if (!t.isReal()) {
                real = false;
            }
            if (t.getBits() != 64) continue;
            bits = 64;
        }
        this.commonType = MatrixType.lookup((boolean)dense, (boolean)real, (int)bits);
    }

    public <T extends SimpleBase<T>> T convert(SimpleBase<?> matrix) {
        Matrix m;
        if (matrix.getType() == this.commonType) {
            return (T)matrix;
        }
        if (!matrix.getType().isDense() && this.commonType.isDense()) {
            System.err.println("\n***** WARNING *****\n");
            System.err.println("Converting a sparse to dense matrix automatically.");
            System.err.println("Current auto convert code isn't that smart and this might have been available");
        }
        if ((m = ConvertMatrixType.convert((Matrix)matrix.mat, (MatrixType)this.commonType)) == null) {
            throw new IllegalArgumentException("Conversion from " + matrix.getType() + " to " + this.commonType + " not possible");
        }
        return (T)matrix.wrapMatrix(m);
    }
}

