/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.lu;

import org.ejml.alg.dense.decomposition.lu.LUDecompositionBase_D64;
import org.ejml.data.DenseMatrix64F;

public class LUDecompositionNR_D64
extends LUDecompositionBase_D64 {
    private static final double TINY = 1.0E-40;

    public boolean decompose(DenseMatrix64F orig) {
        this.decomposeCommonInit(orig);
        for (int i = 0; i < this.m; ++i) {
            double big = 0.0;
            for (int j = 0; j < this.n; ++j) {
                double temp = Math.abs(this.dataLU[i * this.n + j]);
                if (!(big < temp)) continue;
                big = temp;
            }
            if (big == 0.0) {
                big = 1.0;
            }
            this.vv[i] = 1.0 / big;
        }
        for (int k = 0; k < this.n; ++k) {
            int imax = -1;
            double big = 0.0;
            for (int i = k; i < this.m; ++i) {
                double temp = this.vv[i] * this.dataLU[i * this.n + k];
                if (temp < 0.0) {
                    temp = -temp;
                }
                if (!(temp > big)) continue;
                big = temp;
                imax = i;
            }
            if (imax < 0) {
                this.indx[k] = -1;
                return true;
            }
            if (k != imax) {
                int k_n;
                int imax_n = imax * this.n;
                int end = k_n + this.n;
                for (k_n = k * this.n; k_n < end; ++k_n) {
                    double temp = this.dataLU[imax_n];
                    this.dataLU[imax_n] = this.dataLU[k_n];
                    this.dataLU[k_n] = temp;
                    ++imax_n;
                }
                this.pivsign = -this.pivsign;
                this.vv[imax] = this.vv[k];
                int z = this.pivot[imax];
                this.pivot[imax] = this.pivot[k];
                this.pivot[k] = z;
            }
            this.indx[k] = imax;
            double element_kk = this.dataLU[k * this.n + k];
            if (element_kk == 0.0) {
                this.dataLU[k * this.n + k] = 1.0E-40;
                element_kk = 1.0E-40;
            }
            for (int i = k + 1; i < this.m; ++i) {
                int i_n = i * this.n;
                int n = i_n + k;
                double d = this.dataLU[n] / element_kk;
                this.dataLU[n] = d;
                double temp = d;
                int k_n = k * this.n + k + 1;
                int end = i_n + this.n;
                i_n += k + 1;
                while (i_n < end) {
                    int n2 = i_n++;
                    this.dataLU[n2] = this.dataLU[n2] - temp * this.dataLU[k_n];
                    ++k_n;
                }
            }
        }
        return true;
    }
}

